/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.registry.wsclient;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.util.Set;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import java.util.ArrayList;
import java.util.Enumeration;

public class WSClientRegistry {
    public static final int NO_FEATURE = 0;
    public static final int APPLICATION_FEATURE = 1;
    private HashMapObjectObject wsclients = null;

    public boolean contains(WSClientIdentifier id) {
        if (this.wsclients == null) {
            return false;
        }
        return this.wsclients.get((Object)id) != null;
    }

    public void registerWSClient(WSClientIdentifier id, WSClientRuntimeInfo wsClientRuntimeInfo) throws RegistryException {
        if (this.contains(id)) {
            throw new RegistryException("webservices_5012", new Object[]{id, this.getClass().getName()});
        }
        if (this.wsclients == null) {
            this.wsclients = new HashMapObjectObject();
        }
        this.wsclients.put((Object)id, (Object)wsClientRuntimeInfo);
    }

    public void unregisterWSClient(WSClientIdentifier id) {
        if (this.wsclients != null) {
            this.wsclients.remove((Object)id);
        }
    }

    public WSClientRuntimeInfo getWSClient(String applicationName, String wsClientName) throws RegistryException {
        WSClientIdentifier wsClientId = new WSClientIdentifier(applicationName, null, wsClientName);
        return this.getWSClient(wsClientId);
    }

    public WSClientRuntimeInfo getWSClient(WSClientIdentifier id) throws RegistryException {
        if (!this.contains(id)) {
            throw new RegistryException("webservices_5011", new Object[]{id.toString(), this.getClass().getName()});
        }
        return (WSClientRuntimeInfo)this.wsclients.get((Object)id);
    }

    public WSClientRuntimeInfo[] getWSClients() {
        return this.getWSClientsAsArray(this.getWSClientsByFeature(0, ""));
    }

    public WSClientRuntimeInfo[] getWSClientsByApplicationName(String applicationName) {
        return this.getWSClientsAsArray(this.getWSClientsByFeature(1, applicationName));
    }

    public WSClientIdentifier[] listWSClients() {
        return this.getWSClientIdsAsArray(this.listWSClientsByFeature(0, ""));
    }

    public WSClientIdentifier[] listWSClientsByApplicationName(String applicationName) {
        return this.getWSClientIdsAsArray(this.listWSClientsByFeature(1, applicationName));
    }

    public ArrayList listWSClientsByFeature(int featureType, String featureValue) {
        ArrayList<WSClientIdentifier> wsclientsArr = new ArrayList<WSClientIdentifier>();
        if (this.wsclients == null) {
            return wsclientsArr;
        }
        Enumeration wsclientsEnum = this.wsclients.keys();
        while (wsclientsEnum.hasMoreElements()) {
            WSClientIdentifier wsClientId = (WSClientIdentifier)wsclientsEnum.nextElement();
            switch (featureType) {
                case 0: {
                    wsclientsArr.add(wsClientId);
                    break;
                }
                case 1: {
                    if (!wsClientId.getApplicationName().equals(featureValue)) break;
                    wsclientsArr.add(wsClientId);
                }
            }
        }
        return wsclientsArr;
    }

    public ArrayList getWSClientsByFeature(int featureType, String featureValue) {
        ArrayList<Object> wsclientsArr = new ArrayList<Object>();
        if (this.wsclients == null) {
            return wsclientsArr;
        }
        Enumeration wsclientsEnum = this.wsclients.keys();
        while (wsclientsEnum.hasMoreElements()) {
            WSClientIdentifier wsClientId = (WSClientIdentifier)wsclientsEnum.nextElement();
            switch (featureType) {
                case 0: {
                    wsclientsArr.add(this.wsclients.get((Object)wsClientId));
                    break;
                }
                case 1: {
                    if (!wsClientId.getApplicationName().equals(featureValue)) break;
                    wsclientsArr.add(this.wsclients.get((Object)wsClientId));
                }
            }
        }
        return wsclientsArr;
    }

    public String[] listApplications() {
        if (this.wsclients == null) {
            return new String[0];
        }
        Set appNamesSet = new Set();
        Enumeration wsEnum = this.wsclients.keys();
        while (wsEnum.hasMoreElements()) {
            WSClientIdentifier wsClientId = (WSClientIdentifier)wsEnum.nextElement();
            appNamesSet.add((Object)wsClientId.getApplicationName());
        }
        int appNamesSize = appNamesSet.size();
        String[] appNames = new String[appNamesSize];
        Enumeration enumeration = appNamesSet.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            appNames[i++] = (String)enumeration.nextElement();
        }
        return appNames;
    }

    public void reuse() {
        this.wsclients = null;
    }

    private WSClientRuntimeInfo[] getWSClientsAsArray(ArrayList wsClientsArrayList) {
        int wsSize = wsClientsArrayList.size();
        WSClientRuntimeInfo[] wsClientsArray = new WSClientRuntimeInfo[wsSize];
        int i = 0;
        while (i < wsSize) {
            wsClientsArray[i] = (WSClientRuntimeInfo)wsClientsArrayList.get(i);
            ++i;
        }
        return wsClientsArray;
    }

    private WSClientIdentifier[] getWSClientIdsAsArray(ArrayList wsClientIdsArrayList) {
        int wsSize = wsClientIdsArrayList.size();
        WSClientIdentifier[] wsClientIdsArray = new WSClientIdentifier[wsSize];
        int i = 0;
        while (i < wsSize) {
            wsClientIdsArray[i] = (WSClientIdentifier)wsClientIdsArrayList.get(i);
            ++i;
        }
        return wsClientIdsArray;
    }
}

