/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.registry;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.util.Set;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import java.util.ArrayList;
import java.util.Enumeration;

public class WebServiceRegistry {
    public static final int NO_FEATURE = 0;
    public static final int APPLICATION_FEATURE = 1;
    private HashMapObjectObject services = null;

    public void registerWebService(WSRuntimeDefinition wsRuntimeDefintion) throws RegistryException {
        WSIdentifier wsIdentifier;
        if (this.services == null) {
            this.services = new HashMapObjectObject();
        }
        if (this.services.get((Object)(wsIdentifier = wsRuntimeDefintion.getWSIdentifier())) != null) {
            throw new RegistryException("webservices_5012", new Object[]{wsIdentifier, this.getClass().getName()});
        }
        this.services.put((Object)wsIdentifier, (Object)wsRuntimeDefintion);
    }

    public void unregisterWebService(WSIdentifier wsIdentifier) {
        if (this.services != null) {
            this.services.remove((Object)wsIdentifier);
        }
    }

    public boolean contains(String applicationName, String wsName) {
        return this.contains(new WSIdentifier(applicationName, null, wsName));
    }

    public boolean contains(WSIdentifier wsIdentifier) {
        if (this.services == null) {
            return false;
        }
        return this.services.containsKey((Object)wsIdentifier);
    }

    public WSRuntimeDefinition getWebService(String applicationName, String wsName) throws RegistryException {
        WSIdentifier wsIdentifier = new WSIdentifier(applicationName, null, wsName);
        return this.getWebService(wsIdentifier);
    }

    public WSRuntimeDefinition getWebService(WSIdentifier wsIdentifier) throws RegistryException {
        if (this.services != null) {
            return (WSRuntimeDefinition)this.services.get((Object)wsIdentifier);
        }
        throw new RegistryException("webservices_5011", new Object[]{wsIdentifier.toString(), this.getClass().getName()});
    }

    public WSIdentifier[] listWebServices() {
        return this.getWSIdsAsArray(this.listWebServicesByFeature(0, ""));
    }

    public WSIdentifier[] listWebServicesByApplicationName(String applicationName) {
        return this.getWSIdsAsArray(this.listWebServicesByFeature(1, applicationName));
    }

    public ArrayList listWebServicesByFeature(int featureType, String featureValue) {
        ArrayList<WSIdentifier> servicesNamesArr = new ArrayList<WSIdentifier>();
        if (this.services == null) {
            return servicesNamesArr;
        }
        Enumeration servicesEnum = this.services.keys();
        while (servicesEnum.hasMoreElements()) {
            WSIdentifier wsIdentifier = (WSIdentifier)servicesEnum.nextElement();
            switch (featureType) {
                case 0: {
                    servicesNamesArr.add(wsIdentifier);
                    break;
                }
                case 1: {
                    String applicationName = wsIdentifier.getApplicationName();
                    if (!applicationName.equals(featureValue)) break;
                    servicesNamesArr.add(wsIdentifier);
                }
            }
        }
        return servicesNamesArr;
    }

    public WSRuntimeDefinition[] getWebServices() {
        return this.getWSAsArray(this.getWebServicesByFeature(0, ""));
    }

    public WSRuntimeDefinition[] getWebServicesByApplicationName(String applicationName) {
        return this.getWSAsArray(this.getWebServicesByFeature(1, applicationName));
    }

    public ArrayList getWebServicesByFeature(int featureType, String featureValue) {
        ArrayList<WSRuntimeDefinition> servicesArr = new ArrayList<WSRuntimeDefinition>();
        if (this.services == null) {
            return servicesArr;
        }
        Enumeration servicesEnum = this.services.elements();
        while (servicesEnum.hasMoreElements()) {
            WSRuntimeDefinition wsRuntimeDefinition = (WSRuntimeDefinition)servicesEnum.nextElement();
            switch (featureType) {
                case 0: {
                    servicesArr.add(wsRuntimeDefinition);
                    break;
                }
                case 1: {
                    if (!wsRuntimeDefinition.getApplicationName().equals(featureValue)) break;
                    servicesArr.add(wsRuntimeDefinition);
                }
            }
        }
        return servicesArr;
    }

    public String[] listApplications() {
        if (this.services == null) {
            return new String[0];
        }
        Set appNamesSet = new Set();
        Enumeration wsEnum = this.services.elements();
        while (wsEnum.hasMoreElements()) {
            WSRuntimeDefinition wsRuntimeDefinition = (WSRuntimeDefinition)wsEnum.nextElement();
            appNamesSet.add((Object)wsRuntimeDefinition.getApplicationName());
        }
        int appNamesSize = appNamesSet.size();
        String[] appNames = new String[appNamesSize];
        Enumeration enumeration = appNamesSet.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            appNames[i++] = (String)enumeration.nextElement();
        }
        return appNames;
    }

    private WSRuntimeDefinition[] getWSAsArray(ArrayList wsArrayList) {
        int wsSize = wsArrayList.size();
        WSRuntimeDefinition[] wsArray = new WSRuntimeDefinition[wsSize];
        int i = 0;
        while (i < wsSize) {
            wsArray[i] = (WSRuntimeDefinition)wsArrayList.get(i);
            ++i;
        }
        return wsArray;
    }

    private WSIdentifier[] getWSIdsAsArray(ArrayList wsIdsArrayList) {
        int wsSize = wsIdsArrayList.size();
        WSIdentifier[] wsIdsArray = new WSIdentifier[wsSize];
        int i = 0;
        while (i < wsSize) {
            wsIdsArray[i] = (WSIdentifier)wsIdsArrayList.get(i);
            ++i;
        }
        return wsIdsArray;
    }
}

