/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.registry;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import java.util.Enumeration;

public class RuntimeRegistry {
    private HashMapObjectObject serviceEndpoints = null;

    public void registerServiceEndpoint(ServiceEndpointDefinition serviceEndpoint) throws RegistryException {
        String serviceEndpointId;
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new HashMapObjectObject();
        }
        if (this.serviceEndpoints.get((Object)(serviceEndpointId = serviceEndpoint.getServiceEndpointId())) != null) {
            throw new RegistryException("webservices_5012", new Object[]{serviceEndpointId, this.getClass().getName()});
        }
        this.serviceEndpoints.put((Object)serviceEndpointId, (Object)serviceEndpoint);
    }

    public void unregisterServiceEndpoint(String serviceEndpointId) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.remove((Object)serviceEndpointId);
        }
    }

    public boolean contains(String serviceEndpointId) {
        if (this.serviceEndpoints == null) {
            return false;
        }
        return this.serviceEndpoints.containsKey((Object)serviceEndpointId);
    }

    public ServiceEndpointDefinition getServiceEndpoint(String serviceEndpointId) throws RegistryException {
        ServiceEndpointDefinition endPoint;
        if (this.serviceEndpoints != null && (endPoint = (ServiceEndpointDefinition)this.serviceEndpoints.get((Object)serviceEndpointId)) != null) {
            return endPoint;
        }
        throw new RegistryException("webservices_5011", new Object[]{serviceEndpointId, this.getClass().getName()});
    }

    public String[] listServiceEndpoints() {
        if (this.serviceEndpoints == null) {
            return new String[0];
        }
        int serviceEndpointsSize = this.serviceEndpoints.size();
        String[] serviceEndpointsNames = new String[serviceEndpointsSize];
        Enumeration serviceEndpointsEnum = this.serviceEndpoints.keys();
        int i = 0;
        while (serviceEndpointsEnum.hasMoreElements()) {
            serviceEndpointsNames[i++] = (String)serviceEndpointsEnum.nextElement();
        }
        return serviceEndpointsNames;
    }

    public ServiceEndpointDefinition[] getServiceEndpoints() {
        if (this.serviceEndpoints == null) {
            return new ServiceEndpointDefinition[0];
        }
        int serviceEndpointsSize = this.serviceEndpoints.size();
        ServiceEndpointDefinition[] serviceEndpointsArr = new ServiceEndpointDefinition[serviceEndpointsSize];
        Enumeration serviceEndpointsEnum = this.serviceEndpoints.elements();
        int i = 0;
        while (serviceEndpointsEnum.hasMoreElements()) {
            serviceEndpointsArr[i++] = (ServiceEndpointDefinition)serviceEndpointsEnum.nextElement();
        }
        return serviceEndpointsArr;
    }
}

