/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.registry;

import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.runtime.registry.ExtHashtable;
import java.util.ArrayList;

public class OperationMappingRegistry {
    private ExtHashtable operations = new ExtHashtable();

    public ArrayList getOperations(Key[] keys) {
        ArrayList resultSet = this.getAsArray(keys[0]);
        ArrayList tempSet = null;
        int i = 1;
        while (i < keys.length) {
            if (resultSet.size() == 0) {
                return resultSet;
            }
            tempSet = this.getAsArray(keys[i]);
            resultSet = this.getIntersection(resultSet, tempSet);
            ++i;
        }
        return resultSet;
    }

    public void addOperation(Key[] keys, OperationDefinition operation) throws RegistryException {
        ArrayList identicalOperations = this.getOperations(keys);
        if (identicalOperations.size() != 0) {
            throw new RegistryException("webservices_5012", new Object[]{keys, this.getClass().getName(), "operation name '" + operation.getOperationName() + "'"});
        }
        int i = 0;
        while (i < keys.length) {
            this.operations.register(keys[i], operation);
            ++i;
        }
    }

    private ArrayList getAsArray(Key key) {
        Object value = this.operations.get(key);
        if (value == null) {
            return new ArrayList();
        }
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        ArrayList valueAsArr = new ArrayList();
        valueAsArr.add(value);
        return valueAsArr;
    }

    private ArrayList getIntersection(ArrayList set1, ArrayList set2) {
        ArrayList intersectionSet = new ArrayList();
        if (set1 == null || set2 == null) {
            return intersectionSet;
        }
        if (set1.size() == 0 || set2.size() == 0) {
            return intersectionSet;
        }
        int i = 0;
        while (i < set1.size()) {
            Object currentObj = set1.get(i);
            if (set2.contains(currentObj)) {
                intersectionSet.add(currentObj);
            }
            ++i;
        }
        return intersectionSet;
    }

    private String getMessage(Key[] keys, String operationName) {
        String message = "Unable to register operation " + operationName + "\n" + "Operation with the following keys has been registered already: \n";
        int i = 0;
        while (i < keys.length) {
            message = message + "key[" + i + "] = " + keys[i] + "\n";
            ++i;
        }
        return message;
    }

    public String toString() {
        if (this.operations != null) {
            return this.operations.toString();
        }
        return null;
    }
}

