/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.monitor;

import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.monitor.WSConfigData;
import com.sap.engine.services.webservices.runtime.monitor.WSRequest;

public class WSRequests {
    private long successfulRequests = 0L;
    private long failedRequests = 0L;
    private HashMapLongObject runningClients = new HashMapLongObject();
    private HashMapObjectObject wsConfigs = new HashMapObjectObject();
    private long reqCounter = 0L;
    private InstancesPool wsReqPool = new InstancesPool(8, 16);

    public synchronized WSRequest startRequest(ServiceEndpointDefinition endPointDefinition) {
        WSRequest request = (WSRequest)this.wsReqPool.getInstance();
        if (request == null) {
            request = new WSRequest();
        }
        String cfgName = endPointDefinition.getConfigurationName();
        request.owner = this;
        request.requestID = this.reqCounter++;
        request.configName = cfgName;
        request.successful = false;
        request.operationName = null;
        this.runningClients.put(request.requestID, (Object)request);
        this.getConfigData(cfgName);
        return request;
    }

    public synchronized void endRequest(WSRequest request) {
        request = (WSRequest)this.runningClients.remove(request.requestID);
        WSConfigData wsConf = (WSConfigData)this.wsConfigs.get((Object)request.configName);
        if (request.successful) {
            ++this.successfulRequests;
            ++wsConf.successfulReqs;
            wsConf.processOperationData(request);
        } else {
            ++this.failedRequests;
            ++wsConf.failedReqs;
        }
        this.wsReqPool.rollBackInstance(request);
    }

    public long getSuccessfulRequests() {
        return this.successfulRequests;
    }

    public long getFailedRequests() {
        return this.failedRequests;
    }

    public synchronized long getRunningClients() {
        return this.runningClients.getAllKeys().length;
    }

    public synchronized WSConfigData getConfigData(String configName) {
        WSConfigData wsConfig = (WSConfigData)this.wsConfigs.get((Object)configName);
        if (wsConfig == null) {
            wsConfig = new WSConfigData();
            this.wsConfigs.put((Object)configName, (Object)wsConfig);
        }
        return wsConfig;
    }
}

