/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.definition.wsclient;

import com.sap.engine.services.webservices.runtime.definition.wsclient.ComponentDescriptor;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import java.io.Serializable;

public class WSClientRuntimeInfo
implements Serializable {
    protected String version = "6.30";
    protected String linkServiceRefName = null;
    protected WSClientIdentifier wsClientId = null;
    protected String serviceInterfaceName = null;
    protected String packageName = null;
    protected String[] wsdlFileNames = new String[0];
    protected String logicalPortsFileName = null;
    protected String[] uriMappingFiles = new String[0];
    protected String packageMappingFile = null;
    protected ComponentDescriptor[] componentDescriptors = new ComponentDescriptor[0];
    protected WSClientDirsHandler wsClientDirsHandler = null;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLinkServiceRefName() {
        return this.linkServiceRefName;
    }

    public void setLinkServiceRefName(String linkServiceRefName) {
        this.linkServiceRefName = linkServiceRefName;
    }

    public WSClientIdentifier getWsClientId() {
        return this.wsClientId;
    }

    public void setWsClientId(WSClientIdentifier wsClientId) {
        this.wsClientId = wsClientId;
    }

    public String getServiceInterfaceName() {
        return this.serviceInterfaceName;
    }

    public void setServiceInterfaceName(String serviceInterfaceName) {
        this.serviceInterfaceName = serviceInterfaceName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String[] getWsdlFileNames() {
        return this.wsdlFileNames;
    }

    public String[] getWsdlFileNamesRelToWSClientOwnDir() {
        return this.wsClientDirsHandler.getWsdlRelPaths(this.wsdlFileNames);
    }

    public String[] getWsdlFullFileNames() {
        return this.wsClientDirsHandler.getWsdlPaths(this.wsdlFileNames);
    }

    public void setWsdlFileNames(String[] wsdlFileNames) {
        this.wsdlFileNames = wsdlFileNames;
    }

    public String getLogicalPortsFileName() {
        return this.logicalPortsFileName;
    }

    public String getLogicalPortsFileNameRelToWSClientOwnDir() {
        return this.wsClientDirsHandler.getLogPortsRelPath(this.logicalPortsFileName);
    }

    public String getLogicalPortsFullFileName() {
        return this.wsClientDirsHandler.getLogPortsPath(this.logicalPortsFileName);
    }

    public void setLogicalPortsFileName(String logicalPortsFileName) {
        this.logicalPortsFileName = logicalPortsFileName;
    }

    public boolean hasLogicalPortsFile() {
        return this.logicalPortsFileName != null;
    }

    public String[] getUriMappingFiles() {
        return this.uriMappingFiles;
    }

    public String[] getUriMappingFileNamesRelToWSClientOwnDir() {
        return this.wsClientDirsHandler.getUriMappingRelPaths(this.uriMappingFiles);
    }

    public String[] getUriMappingFullFileNames() {
        return this.wsClientDirsHandler.getUriMappingPaths(this.uriMappingFiles);
    }

    public void setUriMappingFiles(String[] uriMappingFiles) {
        this.uriMappingFiles = uriMappingFiles;
    }

    public boolean hasUriMappingFiles() {
        return this.uriMappingFiles != null && this.uriMappingFiles.length != 0;
    }

    public String getPackageMappingFile() {
        return this.packageMappingFile;
    }

    public String getPackageMappingFileRelToWSClientOwnDir() {
        return this.wsClientDirsHandler.getPackageMappingRelPath(this.packageMappingFile);
    }

    public String getPackageMappingFullFileName() {
        return this.wsClientDirsHandler.getPackageMappingPath(this.packageMappingFile);
    }

    public void setPackageMappingFile(String packageMappingFile) {
        this.packageMappingFile = packageMappingFile;
    }

    public boolean hasPackageMappingFile() {
        return this.packageMappingFile != null;
    }

    public ComponentDescriptor[] getComponentDescriptors() {
        return this.componentDescriptors;
    }

    public void setComponentDescriptors(ComponentDescriptor[] componentDescriptors) {
        this.componentDescriptors = componentDescriptors;
    }

    public WSClientDirsHandler getWsClientDirsHandler() {
        return this.wsClientDirsHandler;
    }

    public void setWsClientDirsHandler(WSClientDirsHandler wsClientDirsHandler) {
        this.wsClientDirsHandler = wsClientDirsHandler;
    }

    public String toString() {
        String nl = WSBaseConstants.LINE_SEPARATOR;
        String result = "";
        result = result + this.wsClientId.toString() + nl;
        result = result + "Service interface name: " + this.serviceInterfaceName + nl;
        result = result + "Package : " + this.packageName + nl;
        int wsdlsSize = this.getWsdlFileNames().length;
        int i = 0;
        while (i < wsdlsSize) {
            result = result + "Wsdl file[" + i + "] : " + this.wsdlFileNames[i] + nl;
            ++i;
        }
        if (this.hasLogicalPortsFile()) {
            result = result + " Logical ports file name: " + this.logicalPortsFileName + nl;
        }
        int uriMappingsSize = this.uriMappingFiles.length;
        int i2 = 0;
        while (i2 < uriMappingsSize) {
            result = result + "Uri mapping file: " + this.uriMappingFiles[i2] + nl;
            ++i2;
        }
        if (this.hasPackageMappingFile()) {
            result = result + "Package mapping file: " + this.packageMappingFile + nl;
        }
        int componentsSize = this.getComponentDescriptors().length;
        int i3 = 0;
        while (i3 < componentsSize) {
            result = result + "Client[" + i3 + "] = " + this.componentDescriptors[i3].toString() + nl;
            ++i3;
        }
        return result;
    }
}

