/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.definition.wsclient;

import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import java.io.Serializable;

public class WSClientIdentifier
implements Serializable {
    private String applicationName = null;
    private String jarName = null;
    private String serviceRefName = null;

    public WSClientIdentifier() {
    }

    public WSClientIdentifier(String applicationName, String jarName, String serviceRefName) {
        this.applicationName = applicationName;
        this.jarName = jarName;
        this.serviceRefName = serviceRefName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public WSClientIdentifier(WSClientIdentifier wsClientId) {
        this.serviceRefName = wsClientId.getServiceRefName();
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setServiceRefName(String serviceRefName) {
        this.serviceRefName = serviceRefName;
    }

    public int hashCode() {
        return this.applicationName.hashCode() * this.serviceRefName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WSClientIdentifier)) {
            return false;
        }
        WSClientIdentifier wsClientId = (WSClientIdentifier)obj;
        return this.applicationName.equals(wsClientId.getApplicationName()) && this.serviceRefName.equals(wsClientId.getServiceRefName());
    }

    public String toString() {
        String nl;
        String result = nl = WSBaseConstants.LINE_SEPARATOR;
        result = result + "Application name: " + this.applicationName + nl;
        this.jarName = this.jarName.replace('\\', '/');
        if (this.jarName.indexOf("/") != -1) {
            result = result + "Jar name: " + this.jarName.substring(this.jarName.lastIndexOf("/") + 1) + nl;
        } else {
            result = result + "Jar name: " + this.jarName + nl;
            result = result + "Service reference name: " + this.serviceRefName + nl;
        }
        return result;
    }
}

