/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.definition;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.PropertyDescriptor;
import com.sap.engine.services.webservices.exceptions.BaseComponentInstantiationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.ConfigImpl;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import com.sap.engine.services.webservices.runtime.definition.OperationDefinitionImpl;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.registry.OperationMappingRegistry;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.OutsideInConfiguration;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class ServiceEndpointDefinition
implements Serializable {
    private static final String PROTOCOLORDER_FEATURE_NAME = "http://www.sap.com/webas/630/features/portocol-order/";
    private static final String PROTOCOLORDER_PROPERTY_NAME = "protocolOrder";
    private String configurationName = null;
    private String vInterfaceName = null;
    private String serviceEndpointId = null;
    private OperationDefinition[] operations = null;
    private String serviceEndpointInterface = null;
    private ImplLink implLink = null;
    private String targetServerURL = null;
    private String transportBindingId = null;
    private Config trBindingConfig = null;
    private FeatureInfo[] featuresChain = null;
    private FeatureInfo[] runtimeFeaturesChain = null;
    private String[] orderedProtocolIDs;
    private Hashtable protocolsFeatures = new Hashtable();
    private Config globalFeaturesConfig = null;
    private transient OperationMappingRegistry operationRegistry = null;
    private WSRuntimeDefinition owner = null;
    private String viRelPath = null;
    private QName serviceEndpointQName = null;
    private QName portTypeQName = null;
    private QName wsdlBindingName = null;
    private OutsideInConfiguration outsideInConfiguration = null;
    private String sldName = null;
    private boolean isFastEJB;

    public String getvInterfaceName() {
        return this.vInterfaceName;
    }

    public void setvInterfaceName(String vInterfaceName) {
        this.vInterfaceName = vInterfaceName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setServiceEndpointId(String serviceEndpointId) {
        this.serviceEndpointId = serviceEndpointId;
    }

    public String getServiceEndpointId() {
        return this.serviceEndpointId;
    }

    public void setOperations(OperationDefinition[] operations) {
        this.operations = operations;
    }

    public OperationDefinition[] getOperations() {
        return this.operations;
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setImplLink(ImplLink implLink) {
        this.implLink = implLink;
    }

    public ImplLink getImplLink() {
        return this.implLink;
    }

    public String getTargetServerURL() {
        return this.targetServerURL;
    }

    public void setTargetServerURL(String targetServerURL) {
        this.targetServerURL = targetServerURL;
    }

    public void setTransportBinding(String trBindingId) {
        this.transportBindingId = trBindingId;
    }

    public String getTransportBindingId() {
        return this.transportBindingId;
    }

    public Config getTrBindingConfig() {
        return this.trBindingConfig;
    }

    public void setTrBindingConfig(Config trBindingConfig) {
        this.trBindingConfig = trBindingConfig;
    }

    public void setTrBindingConfig(Properties trBindingProperties) {
        this.trBindingConfig = new ConfigImpl(trBindingProperties);
    }

    public FeatureInfo[] getRuntimeFeaturesChain() {
        return this.runtimeFeaturesChain;
    }

    public String[] getOrderedProtocolIDs() {
        return this.orderedProtocolIDs;
    }

    public Hashtable getProtocolIDFeatureMappings() {
        return this.protocolsFeatures;
    }

    public void setFeaturesChain(FeatureInfo[] featuresChain) {
        if (featuresChain == null) {
            return;
        }
        int i = 0;
        while (i < featuresChain.length) {
            if (featuresChain[i].getFeatureName().startsWith(PROTOCOLORDER_FEATURE_NAME)) {
                this.loadProtocolOrder(featuresChain[i]);
                FeatureInfo[] newFeatureArr = new FeatureInfo[featuresChain.length - 1];
                featuresChain[i] = featuresChain[featuresChain.length - 1];
                System.arraycopy(featuresChain, 0, newFeatureArr, 0, featuresChain.length - 1);
                featuresChain = newFeatureArr;
                break;
            }
            ++i;
        }
        this.featuresChain = featuresChain;
        if (featuresChain != null && featuresChain.length > 0) {
            this.runtimeFeaturesChain = new FeatureInfo[featuresChain.length];
            int i2 = 0;
            while (i2 < this.runtimeFeaturesChain.length) {
                this.runtimeFeaturesChain[i2] = new FeatureInfo();
                this.runtimeFeaturesChain[i2].setName(featuresChain[i2].getFeatureName());
                this.runtimeFeaturesChain[i2].setProtocol(featuresChain[i2].getProtocolID());
                ConfigImpl cfg = new ConfigImpl();
                PropertyDescriptor[] propDescr = featuresChain[i2].getConfiguration().getProperties();
                int p = 0;
                while (p < propDescr.length) {
                    cfg.addProperty(propDescr[p]);
                    ++p;
                }
                this.runtimeFeaturesChain[i2].setConfiguration(cfg);
                ++i2;
            }
            FeatureInfo[] designFeatures = this.owner.getDesigntimeFeatures();
            int i3 = 0;
            while (i3 < designFeatures.length) {
                FeatureInfo curDesignF = designFeatures[i3];
                int j = 0;
                while (j < this.runtimeFeaturesChain.length) {
                    if (this.runtimeFeaturesChain[j].getFeatureName().equals(curDesignF.getFeatureName())) {
                        PropertyDescriptor[] prop = curDesignF.getConfiguration().getProperties();
                        int p = 0;
                        while (p < prop.length) {
                            ((ConfigImpl)this.runtimeFeaturesChain[j].getConfiguration()).addProperty(prop[p]);
                            ++p;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
            this.loadProtocolIDFeatureMappingTable();
            if (this.orderedProtocolIDs == null) {
                Set keySet = this.protocolsFeatures.keySet();
                this.orderedProtocolIDs = keySet.toArray(new String[keySet.size()]);
            }
            String[] finalOrderedProtIDS = new String[this.orderedProtocolIDs.length];
            int count = 0;
            int i4 = 0;
            while (i4 < this.orderedProtocolIDs.length) {
                if (this.protocolsFeatures.get(this.orderedProtocolIDs[i4]) != null) {
                    finalOrderedProtIDS[count++] = this.orderedProtocolIDs[i4];
                }
                ++i4;
            }
            if (count < this.orderedProtocolIDs.length) {
                String[] newArr = new String[count];
                System.arraycopy(finalOrderedProtIDS, 0, newArr, 0, count);
                finalOrderedProtIDS = newArr;
            }
            this.orderedProtocolIDs = finalOrderedProtIDS;
        }
    }

    public FeatureInfo[] getFeaturesChain() {
        if (this.featuresChain == null) {
            this.featuresChain = new FeatureInfo[0];
        }
        return this.featuresChain;
    }

    public Config getGlobalFeaturesConfig() {
        return this.globalFeaturesConfig;
    }

    public void setGlobalFeaturesConfig(Config globalFeaturesConfig) {
        this.globalFeaturesConfig = globalFeaturesConfig;
    }

    public void setOperationMappingRegistry(OperationMappingRegistry operationRegistry) {
        this.operationRegistry = operationRegistry;
    }

    public OperationMappingRegistry getOperationMappingRegistry() {
        return this.operationRegistry;
    }

    public void setOwner(WSRuntimeDefinition owner) {
        this.owner = owner;
    }

    public WSRuntimeDefinition getOwner() {
        return this.owner;
    }

    public String getViRelPath() {
        return this.viRelPath;
    }

    public void setViRelPath(String viRelPath) {
        this.viRelPath = viRelPath;
    }

    public void setServiceEndpointQualifiedName(QName serviceEndpointQName) {
        this.serviceEndpointQName = serviceEndpointQName;
    }

    public QName getServiceEndpointQualifiedName() {
        return this.serviceEndpointQName;
    }

    public void setPortTypeName(QName portTypeQName) {
        this.portTypeQName = portTypeQName;
    }

    public QName getPortTypeName() {
        return this.portTypeQName;
    }

    public void setWsdlBindingName(QName wsdlBindingName) {
        this.wsdlBindingName = wsdlBindingName;
    }

    public QName getWsdlBindingName() {
        return this.wsdlBindingName;
    }

    public String getDocumentWsdlURI(String host, int port) {
        return "http://" + host + ":" + port + this.getDocumentWsdlPathInfo();
    }

    public String getRpcWsdlURI(String host, int port) {
        return "http://" + host + ":" + port + this.getRpcWsdlPathInfo();
    }

    public String getDocumentWsdlPathInfo() {
        if (this.serviceEndpointId.startsWith("/")) {
            return this.serviceEndpointId + "?wsdl=document";
        }
        return "/" + this.serviceEndpointId + "?wsdl=document";
    }

    public String getRpcWsdlPathInfo() {
        if (this.serviceEndpointId.startsWith("/")) {
            return this.serviceEndpointId + "?wsdl=rpc";
        }
        return "/" + this.serviceEndpointId + "?wsdl=rpc";
    }

    public String getVIWsdlName() {
        String viWsdlName = null;
        int index = this.viRelPath.lastIndexOf("/");
        viWsdlName = index != -1 ? this.viRelPath.substring(index + 1) : this.viRelPath;
        return viWsdlName;
    }

    public String getVIWsdlPath(String style, boolean isSapMode) throws Exception {
        return this.getOwner().getWsDirsHandler().getViWsdlPath(this.viRelPath, this.configurationName, style, isSapMode);
    }

    public String getBindingWsdl(String style, boolean isSapMode) throws Exception {
        return this.getOwner().getWsDirsHandler().getBindingWsdlPath(this.configurationName, style, isSapMode);
    }

    public OutsideInConfiguration getOutsideInConfiguration() {
        return this.outsideInConfiguration;
    }

    public void setOutsideInConfiguration(OutsideInConfiguration outsideInConfiguration) {
        this.outsideInConfiguration = outsideInConfiguration;
    }

    private void loadProtocolOrder(FeatureInfo feature) {
        PropertyDescriptor prOrder = feature.getConfiguration().getProperty(PROTOCOLORDER_PROPERTY_NAME);
        if (prOrder != null) {
            StringTokenizer strToken = new StringTokenizer(prOrder.getValue());
            this.orderedProtocolIDs = new String[strToken.countTokens()];
            int counter = 0;
            while (strToken.hasMoreTokens()) {
                this.orderedProtocolIDs[counter++] = strToken.nextToken();
            }
        }
    }

    private void loadProtocolIDFeatureMappingTable() {
        ArrayList<FeatureInfo> list;
        Hashtable<String, Object> hTalbe = new Hashtable<String, Object>();
        FeatureInfo[] features = this.getRuntimeFeaturesChain();
        if (features != null) {
            int i = 0;
            while (i < features.length) {
                block15: {
                    if (features[i].getProtocolID() != null && features[i].getProtocolID().length() != 0) {
                        try {
                            WSContainer.getComponentFactory().getProtocolInstance(features[i].getProtocolID());
                        }
                        catch (BaseComponentInstantiationException bciE) {
                            Location loc = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                            loc.logT(200, "There is no registered protocol for ID: " + features[i].getProtocolID() + ". The protocol is skipped!");
                            break block15;
                        }
                        list = (ArrayList)hTalbe.get(features[i].getProtocolID());
                        if (list == null) {
                            list = new ArrayList<FeatureInfo>();
                            hTalbe.put(features[i].getProtocolID(), list);
                        }
                        list.add(features[i]);
                    }
                }
                ++i;
            }
        }
        String mark = "mark";
        OperationDefinition[] operations = this.getOperations();
        int opSize = operations.length;
        int i = 0;
        while (i < opSize) {
            features = ((OperationDefinitionImpl)operations[i]).getFeaturesChain();
            if (features != null) {
                int j = 0;
                while (j < features.length) {
                    block16: {
                        if (features[j].getProtocolID() != null && features[j].getProtocolID().length() != 0) {
                            try {
                                WSContainer.getComponentFactory().getProtocolInstance(features[j].getProtocolID());
                            }
                            catch (BaseComponentInstantiationException bciE) {
                                Location loc = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                                loc.logT(200, "There is no registered protocol for ID: " + features[j].getProtocolID() + ". The protocol is skipped!");
                                break block16;
                            }
                            if (hTalbe.get(features[j].getProtocolID()) == null) {
                                hTalbe.put(features[j].getProtocolID(), mark);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Enumeration en = hTalbe.keys();
        while (en.hasMoreElements()) {
            Object tmpPId = en.nextElement();
            Object tmpValue = hTalbe.get(tmpPId);
            if (tmpValue instanceof ArrayList) {
                list = (ArrayList<FeatureInfo>)tmpValue;
                this.protocolsFeatures.put(tmpPId, list.toArray(new Feature[list.size()]));
                continue;
            }
            this.protocolsFeatures.put(tmpPId, new Feature[0]);
        }
    }

    public String getSldName() {
        return this.sldName;
    }

    public void setSldName(String sldName) {
        this.sldName = sldName;
    }

    public boolean isFastEJB() {
        return this.isFastEJB;
    }

    public void setFastEJB(boolean b) {
        this.isFastEJB = b;
    }
}

