/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.definition;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Fault;
import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ParameterNode;
import com.sap.engine.services.webservices.runtime.definition.ConfigImpl;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import java.util.Properties;

public class OperationDefinitionImpl
implements OperationDefinition {
    private String uniqueOperationName = null;
    private String javaOperationName;
    private String operationName;
    private FeatureInfo[] featuresChain;
    private boolean isExposed = true;
    private Config generalConfig;
    private Config inputConfig;
    private Config outputConfig;
    private String description;
    private ParameterNode[] inputParams;
    private ParameterNode[] outputParams;
    private Fault[] faults;
    private Key[] keys = null;
    private String inputConfigDefaultNS;
    private String outputConfigDefaultNS;

    public String getUniqueOperationName() {
        return this.uniqueOperationName;
    }

    public void setUniqueOperationName(String uniqueOperationName) {
        this.uniqueOperationName = uniqueOperationName;
    }

    public void setJavaOperationName(String javaOperationName) {
        this.javaOperationName = javaOperationName;
    }

    public String getJavaOperationName() {
        return this.javaOperationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Feature[] getFeatures() {
        return this.featuresChain;
    }

    public void setInputParameters(ParameterNode[] inputParams) {
        this.inputParams = inputParams;
    }

    public ParameterNode[] getInputParameters() {
        return this.inputParams;
    }

    public void setOutputParameters(ParameterNode[] outputParams) {
        this.outputParams = outputParams;
    }

    public ParameterNode[] getOutputParameters() {
        return this.outputParams;
    }

    public String getDescription() {
        return this.description;
    }

    public Feature getFeature(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException("Feature name could not be 'null'");
        }
        int i = 0;
        while (i < this.featuresChain.length) {
            if (this.featuresChain[i].getFeatureName().equals(featureName)) {
                return this.featuresChain[i];
            }
            ++i;
        }
        return null;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFeaturesChain(FeatureInfo[] featuresChain) {
        this.featuresChain = featuresChain;
    }

    public FeatureInfo[] getFeaturesChain() {
        return this.featuresChain;
    }

    public boolean isExposed() {
        return this.isExposed;
    }

    public void setExposed(boolean exposed) {
        this.isExposed = exposed;
    }

    public void setGeneralConfiguration(Config generalConfig) {
        this.generalConfig = generalConfig;
    }

    public void setGeneralConfiguration(Properties properties) {
        this.generalConfig = new ConfigImpl(properties);
    }

    public Config getGeneralConfiguration() {
        return this.generalConfig;
    }

    public void setInputOperationConfiguration(Config config) {
        this.inputConfig = config;
    }

    public void setInputOperationConfiguration(Properties properties) {
        this.inputConfig = new ConfigImpl(properties);
    }

    public Config getInputConfiguration() {
        return this.inputConfig;
    }

    public void setOutputOperationConfiguration(Config config) {
        this.outputConfig = config;
    }

    public void setOutputOperationConfiguration(Properties properties) {
        this.outputConfig = new ConfigImpl(properties);
    }

    public Config getOutputConfiguration() {
        return this.outputConfig;
    }

    public void setFaults(Fault[] faults) {
        this.faults = faults;
    }

    public Fault[] getFaults() {
        return this.faults;
    }

    public void setKeys(Key[] keys) {
        this.keys = keys;
    }

    public Key[] getKeys() {
        return this.keys;
    }

    public String getInputConfigDefaultNS() {
        return this.inputConfigDefaultNS;
    }

    public void setInputConfigDefaultNS(String inputConfigDefaultNS) {
        this.inputConfigDefaultNS = inputConfigDefaultNS;
    }

    public String getOutputConfigDefaultNS() {
        return this.outputConfigDefaultNS;
    }

    public void setOutputConfigDefaultNS(String outputConfigDefaultNS) {
        this.outputConfigDefaultNS = outputConfigDefaultNS;
    }

    public String toString() {
        String result = "";
        result = result + "operation name: '" + this.operationName + "'\n";
        result = result + "javaOperation name: '" + this.javaOperationName + "'\n";
        if (this.keys != null) {
            result = result + "Keys: \n" + this.toString(this.keys) + "\n";
        }
        if (this.inputParams != null) {
            result = result + "InputParams: \n" + this.toString(this.inputParams) + "\n";
        }
        if (this.outputParams != null) {
            result = result + "OutputParams: \n" + this.toString(this.outputParams) + "\n";
        }
        if (this.faults != null) {
            result = result + "Faults: \n" + this.faults.toString() + "\n";
        }
        return result;
    }

    public String toString(Object[] objArray) {
        String result = "";
        if (objArray == null) {
            return result;
        }
        int length = objArray.length;
        int i = 0;
        while (i < length) {
            result = result + "element[" + i + "] = " + objArray[i].toString();
            ++i;
        }
        return result;
    }
}

