/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.definition;

import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaToQNameMappingsImpl
implements JavaToQNameMappings {
    private static HashMap standardMappings = new HashMap(22);
    private HashMap javaToQNameMappings;
    private HashMap qnameToJavaMappings;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;

    public JavaToQNameMappingsImpl(HashMap mappings) {
        this.javaToQNameMappings = mappings;
        this.qnameToJavaMappings = this.reverseKeyValues(this.javaToQNameMappings);
    }

    public JavaToQNameMappingsImpl() {
        this.javaToQNameMappings = new HashMap();
        this.qnameToJavaMappings = new HashMap();
    }

    public static boolean isBuiltInSchemaType(String javaClassName) {
        return standardMappings.containsKey(javaClassName);
    }

    public QName getMappedQName(String javaClassName) {
        return (QName)(standardMappings.get(javaClassName) != null ? standardMappings.get(javaClassName) : this.javaToQNameMappings.get(javaClassName));
    }

    public String getMappedJavaClass(QName qname) {
        return (String)this.qnameToJavaMappings.get(qname);
    }

    public HashMap getQNameToJavaMappings() {
        return this.qnameToJavaMappings;
    }

    public HashMap getJavaToQNameMappings() {
        return (HashMap)this.javaToQNameMappings.clone();
    }

    Element writeToDOMElement(Element parentElement) {
        Set keySet = this.javaToQNameMappings.keySet();
        Iterator itr = keySet.iterator();
        while (itr.hasNext()) {
            Object tempObject = itr.next();
            QName tempValue = (QName)this.javaToQNameMappings.get(tempObject);
            Element tempElement = parentElement.getOwnerDocument().createElement("entry");
            tempElement.setAttribute("javaClass", (String)tempObject);
            tempElement.setAttribute("uri", tempValue.getNamespaceURI());
            tempElement.setAttribute("localName", tempValue.getLocalPart());
            parentElement.appendChild(tempElement);
        }
        return parentElement;
    }

    void loadFromDOMElement(Element parentElement) throws Exception {
        NodeList childs = parentElement.getElementsByTagName("entry");
        int i = 0;
        while (i < childs.getLength()) {
            Element tempElement = (Element)childs.item(i);
            String javaClass = tempElement.getAttribute("javaClass");
            String uri = tempElement.getAttribute("uri");
            String localName = tempElement.getAttribute("localName");
            if (javaClass.length() <= 0 || uri.length() <= 0 || localName.length() <= 0) {
                throw new Exception("Incorrect element found." + tempElement.toString());
            }
            this.javaToQNameMappings.put(javaClass, new QName(uri, localName));
            ++i;
        }
        this.qnameToJavaMappings = this.reverseKeyValues(this.javaToQNameMappings);
    }

    public String toString() {
        return this.javaToQNameMappings.toString();
    }

    private HashMap reverseKeyValues(HashMap map) {
        QName value;
        String key;
        HashMap<QName, String> newMap = new HashMap<QName, String>();
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            key = (String)itr.next();
            value = (QName)map.get(key);
            newMap.put(value, key);
        }
        itr = standardMappings.keySet().iterator();
        while (itr.hasNext()) {
            key = (String)itr.next();
            value = (QName)map.get(key);
            newMap.put(value, key);
        }
        return newMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        standardMappings.put("boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        standardMappings.put("byte", new QName("http://www.w3.org/2001/XMLSchema", "byte"));
        standardMappings.put("short", new QName("http://www.w3.org/2001/XMLSchema", "short"));
        standardMappings.put("int", new QName("http://www.w3.org/2001/XMLSchema", "int"));
        standardMappings.put("long", new QName("http://www.w3.org/2001/XMLSchema", "long"));
        standardMappings.put("float", new QName("http://www.w3.org/2001/XMLSchema", "float"));
        standardMappings.put("double", new QName("http://www.w3.org/2001/XMLSchema", "double"));
        standardMappings.put("char", new QName("http://www.w3.org/2001/XMLSchema", "string"));
        standardMappings.put("java.lang.String", new QName("http://www.w3.org/2001/XMLSchema", "string"));
        standardMappings.put("java.math.BigInteger", new QName("http://www.w3.org/2001/XMLSchema", "integer"));
        standardMappings.put("java.math.BigDecimal", new QName("http://www.w3.org/2001/XMLSchema", "decimal"));
        standardMappings.put("java.util.Calendar", new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        standardMappings.put("java.util.Date", new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        standardMappings.put((class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = JavaToQNameMappingsImpl.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar).getName(), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        standardMappings.put((class$java$sql$Date == null ? (class$java$sql$Date = JavaToQNameMappingsImpl.class$("java.sql.Date")) : class$java$sql$Date).getName(), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        standardMappings.put((class$java$sql$Time == null ? (class$java$sql$Time = JavaToQNameMappingsImpl.class$("java.sql.Time")) : class$java$sql$Time).getName(), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        standardMappings.put("java.lang.Integer", new QName("http://www.w3.org/2001/XMLSchema", "int"));
        standardMappings.put("java.lang.Float", new QName("http://www.w3.org/2001/XMLSchema", "float"));
        standardMappings.put("java.lang.Double", new QName("http://www.w3.org/2001/XMLSchema", "double"));
        standardMappings.put("java.lang.Boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        standardMappings.put("java.lang.Short", new QName("http://www.w3.org/2001/XMLSchema", "short"));
        standardMappings.put("java.lang.Byte", new QName("http://www.w3.org/2001/XMLSchema", "byte"));
        standardMappings.put("java.lang.Long", new QName("http://www.w3.org/2001/XMLSchema", "long"));
        standardMappings.put("java.lang.Character", new QName("http://www.w3.org/2001/XMLSchema", "string"));
        standardMappings.put("byte[]", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        standardMappings.put("java.lang.Object", new QName("http://www.w3.org/2001/XMLSchema", "anyType"));
    }
}

