/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.definition;

import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappings;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingsImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JavaToQNameMappingRegistryImpl
implements JavaToQNameMappingRegistry {
    private static final String ROOT_ELEMENT_NAME = "javaToQNameMappings";
    private static final String LITERAL_WRAPPER_NAME = "literalmappings";
    private static final String ENCODED_WRAPPER_NAME = "encodedmappings";
    private JavaToQNameMappingsImpl encodedMappings;
    private JavaToQNameMappingsImpl literalMappings;

    public JavaToQNameMappingRegistryImpl() {
        this.literalMappings = this.encodedMappings = new JavaToQNameMappingsImpl();
    }

    public JavaToQNameMappings getEncodedMappings() {
        return this.encodedMappings;
    }

    public void setEncodedMappings(JavaToQNameMappingsImpl encodedMappings) {
        this.encodedMappings = encodedMappings;
    }

    public void setEncodedMappings(HashMap encodedMappings) {
        this.encodedMappings = new JavaToQNameMappingsImpl(encodedMappings);
    }

    public JavaToQNameMappings getLiteralMappings() {
        return this.literalMappings;
    }

    public void setLiteralMappings(JavaToQNameMappingsImpl literalMappings) {
        this.literalMappings = literalMappings;
    }

    public void setLiteralMappings(HashMap literalMappings) {
        this.literalMappings = new JavaToQNameMappingsImpl(literalMappings);
    }

    public void saveToFile(File file) throws Exception {
        Document document = new DocumentBuilderFactoryImpl().newDocumentBuilder().newDocument();
        Element rootElement = document.createElement(ROOT_ELEMENT_NAME);
        Element literalMappings = document.createElement(LITERAL_WRAPPER_NAME);
        rootElement.appendChild(this.literalMappings.writeToDOMElement(literalMappings));
        Element encodedMappings = document.createElement(ENCODED_WRAPPER_NAME);
        rootElement.appendChild(this.encodedMappings.writeToDOMElement(encodedMappings));
        document.appendChild(rootElement);
        Transformer transformer = new TransformerFactoryImpl().newTransformer();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        transformer.transform(new DOMSource(document), new StreamResult(fileOutputStream));
        fileOutputStream.close();
    }

    public String toString() {
        return "\tLiteralMappings: " + this.literalMappings + "\n" + "\tEncodedMappings: " + this.encodedMappings + "\n";
    }

    public static final JavaToQNameMappingRegistryImpl loadFromFile(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        DocumentBuilder documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
        Document document = documentBuilder.parse(fileInputStream);
        JavaToQNameMappingRegistryImpl registry = new JavaToQNameMappingRegistryImpl();
        NodeList list = document.getDocumentElement().getElementsByTagName(LITERAL_WRAPPER_NAME);
        if (list.getLength() == 1) {
            registry.literalMappings = new JavaToQNameMappingsImpl();
            registry.literalMappings.loadFromDOMElement((Element)list.item(0));
        }
        if ((list = document.getDocumentElement().getElementsByTagName(ENCODED_WRAPPER_NAME)).getLength() == 1) {
            registry.encodedMappings = new JavaToQNameMappingsImpl();
            registry.encodedMappings.loadFromDOMElement((Element)list.item(0));
        }
        return registry;
    }
}

