/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.definition;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.PropertyDescriptor;
import com.sap.engine.services.webservices.runtime.definition.PropertyDescriptorInterfaceImpl;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public final class ConfigImpl
implements Config {
    private Map properties;

    public ConfigImpl() {
        this.properties = new HashMap();
    }

    public ConfigImpl(Map properties) {
        this.properties = properties;
    }

    public PropertyDescriptor getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("Key could not be 'null'");
        }
        return (PropertyDescriptor)this.properties.get(key);
    }

    public PropertyDescriptor[] getProperties() {
        Collection col = this.properties.values();
        return col.toArray(new PropertyDescriptor[col.size()]);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, new PropertyDescriptorInterfaceImpl(key, value));
    }

    public void addProperty(PropertyDescriptor property) {
        String name = property.getPropertyDescriptorName();
        if (name == null) {
            throw new NullPointerException("Property name can be 'null'");
        }
        this.properties.put(name, property);
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void addProperties(Hashtable newProperties) {
        if (this.properties == null) {
            this.properties = newProperties;
        }
        Enumeration enumeration = newProperties.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            this.properties.put(key, newProperties.get(key));
        }
    }

    public String toString() {
        return this.properties.toString();
    }
}

