/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.component;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.webservices.runtime.EventObject;
import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.runtime.ImplementationContainer;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.RuntimeProcessException;
import com.sap.engine.interfaces.webservices.runtime.component.BaseRegistryException;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.EJBImplementationContainer;
import com.sap.engine.services.webservices.runtime.JavaClassImplementationContainer;
import com.sap.engine.services.webservices.runtime.ServerRuntimeProcessException;
import com.sap.tc.logging.Location;
import java.util.Enumeration;

public final class ImplementationContainerManager {
    private HashMapObjectObject table = new HashMapObjectObject();
    private EJBImplementationContainer ejbImplContainer;
    private JavaClassImplementationContainer javaClassImplContainer;

    public ImplementationContainerManager(ServiceContext serviceContext) {
        this();
        this.ejbImplContainer = new EJBImplementationContainer(serviceContext);
        this.table.put((Object)this.ejbImplContainer.getImplementationID(), (Object)this.ejbImplContainer);
        this.javaClassImplContainer = new JavaClassImplementationContainer(serviceContext);
        this.table.put((Object)this.javaClassImplContainer.getImplementationID(), (Object)this.javaClassImplContainer);
    }

    public ImplementationContainerManager() {
    }

    public synchronized void register(ImplementationContainer implContainer) throws BaseRegistryException {
        Object old = this.table.put((Object)implContainer.getImplementationID(), (Object)implContainer);
        if (old != null) {
            this.table.put((Object)((ImplementationContainer)old).getImplementationID(), old);
            throw new BaseRegistryException("There is already registred implementation container with ID '" + implContainer.getImplementationID() + "'");
        }
    }

    public synchronized void unregister(String implContainerId) {
        this.table.remove((Object)implContainerId);
    }

    public ImplementationContainer getImplementationContainer(RuntimeContext context) throws ServerRuntimeProcessException {
        ImplLink implLink = context.getImplementationLink();
        ImplementationContainer result = (ImplementationContainer)this.table.get((Object)implLink.getImplId());
        if (result != null) {
            return result;
        }
        throw new ServerRuntimeProcessException("webservices_2003", new Object[]{implLink});
    }

    public final void clearApplicationCaches(String applicationName) {
        EventObject stopAppEvent = new EventObject("http://www.sap.com/webas/630/soap/features/java/implevent/stop-application", (Object)applicationName);
        ImplementationContainerManager implementationContainerManager = this;
        synchronized (implementationContainerManager) {
            Enumeration en = this.table.elements();
            while (en.hasMoreElements()) {
                ImplementationContainer implContainer = (ImplementationContainer)en.nextElement();
                try {
                    implContainer.notify(stopAppEvent, null);
                }
                catch (RuntimeProcessException rtpE) {
                    Location.getLocation((String)WSLogging.RUNTIME_LOCATION).catching((Throwable)rtpE);
                }
            }
        }
    }

    public final void registerTimeoutListeners(TimeoutManager timeoutManager) {
        this.ejbImplContainer.registerTimeoutListeners(timeoutManager);
        this.javaClassImplContainer.registerTimeoutListeners(timeoutManager);
    }

    public void invalidateSession(RuntimeContext context, String sessionID) {
        EventObject invSessEvent = new EventObject("http://www.sap.com/webas/630/soap/features/java/implevent/invalidate-session", (Object)sessionID);
        try {
            ImplementationContainer implContainer = this.getImplementationContainer(context);
            implContainer.notify(invSessEvent, context);
        }
        catch (RuntimeProcessException rtpE) {
            Location.getLocation((String)WSLogging.RUNTIME_LOCATION).catching((Throwable)rtpE);
        }
    }
}

