/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.component;

import com.sap.engine.interfaces.webservices.runtime.component.BaseFactory;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import java.util.Enumeration;

public class ComponentRegistry {
    private HashMapObjectObject components = null;

    protected ComponentRegistry() {
    }

    public boolean contains(String componentId) {
        if (this.components == null) {
            return false;
        }
        return this.components.get((Object)componentId) != null;
    }

    public BaseFactory getComponent(String componentId) throws RegistryException {
        if (!this.contains(componentId)) {
            throw new RegistryException("webservices_5011", new Object[]{componentId, this.getClass().getName()});
        }
        return (BaseFactory)this.components.get((Object)componentId);
    }

    public String[] listComponentIds() {
        String[] componentIdsArr = new String[]{};
        if (this.components != null) {
            componentIdsArr = new String[this.components.size()];
            Enumeration componentsEnum = this.components.keys();
            int i = 0;
            while (componentsEnum.hasMoreElements()) {
                componentIdsArr[i++] = (String)componentsEnum.nextElement();
            }
        }
        return componentIdsArr;
    }

    public BaseFactory[] listComponents() {
        if (this.components != null) {
            BaseFactory[] componentsArr = new BaseFactory[this.components.size()];
            Enumeration componentsEnum = this.components.elements();
            int i = 0;
            while (componentsEnum.hasMoreElements()) {
                componentsArr[i++] = (BaseFactory)componentsEnum.nextElement();
            }
            return componentsArr;
        }
        return new BaseFactory[0];
    }

    public void registerComponent(String componentId, BaseFactory component) throws RegistryException {
        if (this.contains(componentId)) {
            throw new RegistryException("webservices_5012", new Object[]{componentId, this.getClass().getName()});
        }
        if (this.components == null) {
            this.components = new HashMapObjectObject();
        }
        this.components.put((Object)componentId, (Object)component);
    }

    public void unregisterComponent(String componentId) {
        if (this.components != null) {
            this.components.remove((Object)componentId);
        }
    }
}

