/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.component;

import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.runtime.Protocol;
import com.sap.engine.interfaces.webservices.runtime.TransportBinding;
import com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ClientProtocolFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ClientTransportBindingFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ComponentFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ProtocolFactory;
import com.sap.engine.interfaces.webservices.runtime.component.TransportBindingFactory;
import com.sap.engine.services.webservices.exceptions.BaseComponentInstantiationException;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.server.WSContainer;

public class ComponentFactoryImpl
implements ComponentFactory,
ClientComponentFactory {
    public Protocol getProtocolInstance(String id) throws BaseComponentInstantiationException {
        Protocol protocolInterface = null;
        try {
            ProtocolFactory protocolFactory = WSContainer.getProtocolFactoryRegistry().getProtocolFactory(id);
            protocolInterface = protocolFactory.newInstance();
        }
        catch (RegistryException e) {
            Object[] args = new Object[]{"there is no protocol factory registered", id, "protocol"};
            throw new BaseComponentInstantiationException("webservices_5020", args, (Throwable)((Object)e));
        }
        return protocolInterface;
    }

    public TransportBinding getTransportBindingInstance(String id) throws BaseComponentInstantiationException {
        TransportBinding transportBindingInterface = null;
        try {
            TransportBindingFactory transportBindingFactory = WSContainer.getTransportBindingFactoryRegistry().getTransportBindingFactory(id);
            transportBindingInterface = transportBindingFactory.newInstance();
        }
        catch (RegistryException e) {
            Object[] args = new Object[]{"there is no transport binding factory registered", id, "transport binding"};
            throw new BaseComponentInstantiationException("webservices_5020", args, (Throwable)((Object)e));
        }
        return transportBindingInterface;
    }

    public String[] listProtocolIds() {
        return WSContainer.getProtocolFactoryRegistry().listComponentIds();
    }

    public String[] listTransportBindingIds() {
        return WSContainer.getTransportBindingFactoryRegistry().listComponentIds();
    }

    public Protocol[] listProtocolInterfaces() {
        ProtocolFactory[] factories = WSContainer.getProtocolFactoryRegistry().listProtocolFactories();
        int factoriesSize = factories.length;
        Protocol[] interfaces = new Protocol[factoriesSize];
        int i = 0;
        while (i < factoriesSize) {
            interfaces[i] = factories[i].newInstance();
            ++i;
        }
        return interfaces;
    }

    public TransportBinding[] listTransportBindingInterfaces() {
        TransportBindingFactory[] factories = WSContainer.getTransportBindingFactoryRegistry().listTransportBindingFactories();
        int factoriesSize = factories.length;
        TransportBinding[] interfaces = new TransportBinding[factoriesSize];
        int i = 0;
        while (i < factoriesSize) {
            interfaces[i] = factories[i].newInstance();
            ++i;
        }
        return interfaces;
    }

    public ClientFeatureProvider getClientProtocolInstance(String id) throws BaseComponentInstantiationException {
        ClientFeatureProvider clientProtocolInterface = null;
        try {
            ClientProtocolFactory clientProtocolFactory = WSContainer.getClientProtocolFactoryRegistry().getClientProtocolFactory(id);
            clientProtocolInterface = clientProtocolFactory.newInstance();
        }
        catch (RegistryException e) {
            Object[] args = new Object[]{"there is no client protocol factory registered", id, "client protocol"};
            throw new BaseComponentInstantiationException("webservices_5020", args, (Throwable)((Object)e));
        }
        return clientProtocolInterface;
    }

    public ClientFeatureProvider getClientTransportBindingInstance(String id) throws BaseComponentInstantiationException {
        ClientFeatureProvider clientFeatureProviderInterface = null;
        try {
            ClientTransportBindingFactory clientTransportBindingFactory = WSContainer.getClientTransportBindingFactoryRegistry().getClientTransportBindingFactory(id);
            clientFeatureProviderInterface = clientTransportBindingFactory.newInstance();
        }
        catch (RegistryException e) {
            Object[] args = new Object[]{"there is no client transport binding factory registered", id, "client transport binding"};
            throw new BaseComponentInstantiationException("webservices_5020", args, (Throwable)((Object)e));
        }
        return clientFeatureProviderInterface;
    }

    public String[] listClientProtocolIds() {
        return WSContainer.getClientProtocolFactoryRegistry().listComponentIds();
    }

    public String[] listClientTransportBindingIds() {
        return WSContainer.getClientTransportBindingFactoryRegistry().listComponentIds();
    }

    public ClientFeatureProvider[] listClientProtocolInterfaces() {
        ClientProtocolFactory[] factories = WSContainer.getClientProtocolFactoryRegistry().listClientProtocolFactories();
        int factoriesSize = factories.length;
        ClientFeatureProvider[] interfaces = new ClientFeatureProvider[factoriesSize];
        int i = 0;
        while (i < factoriesSize) {
            interfaces[i] = factories[i].newInstance();
            ++i;
        }
        return interfaces;
    }

    public ClientFeatureProvider[] listClientransportBindingInterfaces() {
        ClientTransportBindingFactory[] factories = WSContainer.getClientTransportBindingFactoryRegistry().listClientTransportBindingFactories();
        int factoriesSize = factories.length;
        ClientFeatureProvider[] interfaces = new ClientFeatureProvider[factoriesSize];
        int i = 0;
        while (i < factoriesSize) {
            interfaces[i] = factories[i].newInstance();
            ++i;
        }
        return interfaces;
    }
}

