/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.WSRuntimeContext;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.services.webservices.runtime.RuntimeProcessor;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import java.util.Vector;

public class WSRuntimeContextImpl
implements WSRuntimeContext {
    private WSRuntimeDefinition wsRuntimeDefinition = null;
    private RuntimeContext[] seiRuntimeContexts = new RuntimeContext[0];

    public WSRuntimeContextImpl() {
    }

    public WSRuntimeContextImpl(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        this.init(wsRuntimeDefinition);
    }

    public void init(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        this.wsRuntimeDefinition = wsRuntimeDefinition;
        Vector warnings = new Vector();
        this.createSEIRuntimeContexts(wsRuntimeDefinition, warnings);
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public WSRuntimeDefinition getAssociatedWebService() {
        return this.wsRuntimeDefinition;
    }

    public String getApplicationName() {
        return this.wsRuntimeDefinition.getWSIdentifier().getApplicationName();
    }

    public String getWebServiceName() {
        return this.wsRuntimeDefinition.getWSIdentifier().getServiceName();
    }

    public RuntimeContext[] getSEIRuntimeContexts() {
        return this.seiRuntimeContexts;
    }

    public void clear() {
        this.wsRuntimeDefinition = null;
        this.seiRuntimeContexts = new RuntimeContext[0];
    }

    public RuntimeContext[] createSEIRuntimeContexts(WSRuntimeDefinition wsRuntimeDefinition, Vector warnings) {
        String warningMsg = "Error occured, initializing web service runtime context. Web Service: " + wsRuntimeDefinition.getWSIdentifier() + ". ";
        Vector seiWarnings = new Vector();
        RuntimeContext[] seiRuntimeContexts = this.createSEIRuntimeContexts(wsRuntimeDefinition.getServiceEndpointDefinitions(), seiWarnings);
        if (seiWarnings != null) {
            Vector newSeiWarnings = WSUtil.addPrefixToStrings(warningMsg, seiWarnings);
            warnings.addAll(newSeiWarnings);
        }
        return seiRuntimeContexts;
    }

    public RuntimeContext[] createSEIRuntimeContexts(ServiceEndpointDefinition[] endpointDefintions, Vector warnings) {
        if (endpointDefintions == null) {
            return new RuntimeContext[0];
        }
        RuntimeContext[] seiRuntimeContexts = new RuntimeContext[endpointDefintions.length];
        int i = 0;
        while (i < endpointDefintions.length) {
            ServiceEndpointDefinition endpointDefinition = endpointDefintions[i];
            RuntimeContext runtimeContext = null;
            try {
                runtimeContext = RuntimeProcessor.initilizeRuntimeContext(endpointDefinition);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            seiRuntimeContexts[i] = runtimeContext;
            ++i;
        }
        return seiRuntimeContexts;
    }
}

