/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.InstanceWrapper;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import javax.ejb.EJBObject;

public class StatelessTable
implements TimeoutListener {
    private HashMapObjectObject hashTable = new HashMapObjectObject();

    public synchronized InstancesPool getPool(String key) {
        InstancesPool pool = (InstancesPool)this.hashTable.get((Object)key);
        if (pool != null) {
            return pool;
        }
        pool = new InstancesPool();
        this.hashTable.put((Object)key, (Object)pool);
        return pool;
    }

    public void rollBackInstance(InstanceWrapper instance) {
        if (instance == null) {
            return;
        }
        InstancesPool pool = instance.getOwnerPool();
        pool.rollBackInstance(instance);
    }

    public synchronized Enumeration keys() {
        return this.hashTable.keys();
    }

    public synchronized InstancesPool get(String key) {
        return (InstancesPool)this.hashTable.get((Object)key);
    }

    public boolean check() {
        return true;
    }

    public void timeout() {
        Object[] keys;
        long endTime = System.currentTimeMillis();
        StatelessTable statelessTable = this;
        synchronized (statelessTable) {
            keys = this.hashTable.getAllKeys();
        }
        int i = 0;
        while (i < keys.length) {
            InstancesPool pool;
            InstancesPool instancesPool = pool = this.get((String)keys[i]);
            synchronized (instancesPool) {
                int j = 0;
                while (j < pool.size()) {
                    InstanceWrapper instWrapper = (InstanceWrapper)pool.get(j);
                    if (endTime - instWrapper.getLastActiveTime() > instWrapper.getSessionTimeout()) {
                        Location loc = instWrapper.logLocation != null ? instWrapper.logLocation : Location.getLocation((String)WSLogging.RUNTIME_LOCATION);
                        try {
                            pool.remove(j--);
                            Object obj = instWrapper.getInstance();
                            if (obj instanceof EJBObject) {
                                ((EJBObject)obj).remove();
                            }
                            loc.logT(200, "Removing stateless instance: " + instWrapper.getInstance() + " from pool " + instWrapper.getCacheKey());
                        }
                        catch (Exception e) {
                            loc.catching("Exception in removing stateless object: [" + instWrapper.getInstance() + "]", (Throwable)e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

