/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.InstanceWrapper;
import com.sap.engine.services.webservices.runtime.ServerRuntimeProcessException;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import javax.ejb.EJBObject;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class SessionTable
implements HttpSessionBindingListener {
    private HashMapObjectObject hashTable = new HashMapObjectObject();

    public synchronized InstanceWrapper registerInstanceInuse(InstanceWrapper instanceWrapper) throws ServerRuntimeProcessException {
        String id = instanceWrapper.getCacheKey();
        instanceWrapper.setInuse(true);
        InstanceWrapper prevInstance = (InstanceWrapper)this.hashTable.put((Object)id, (Object)instanceWrapper);
        if (prevInstance != null) {
            this.hashTable.put((Object)id, (Object)prevInstance);
            throw new ServerRuntimeProcessException("webservices_2018", new Object[]{id});
        }
        return instanceWrapper;
    }

    public synchronized InstanceWrapper getInstance(String id) throws ServerRuntimeProcessException {
        InstanceWrapper instance = (InstanceWrapper)this.hashTable.get((Object)id);
        if (instance == null) {
            return null;
        }
        if (instance.isInuse()) {
            throw new ServerRuntimeProcessException("webservices_2018", new Object[]{id});
        }
        instance.setInuse(true);
        return instance;
    }

    public synchronized void rollbackInstance(String sessionID, InstanceWrapper instance) throws ServerRuntimeProcessException {
        if (instance == null && (instance = this.getInstance(sessionID)) == null) {
            return;
        }
        instance.setInuse(false);
    }

    public synchronized void removeInstance(String id) {
        InstanceWrapper instance = (InstanceWrapper)this.hashTable.remove((Object)id);
        if (instance != null && !instance.isInuse()) {
            this.removeInstance(instance);
        }
    }

    public synchronized Enumeration keys() {
        return this.hashTable.keys();
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public synchronized void valueUnbound(HttpSessionBindingEvent event) {
        String bindID = event.getName();
        this.removeInstance(bindID);
    }

    private void removeInstance(InstanceWrapper instance) {
        Location loc = instance.logLocation != null ? instance.logLocation : Location.getLocation((String)WSLogging.RUNTIME_LOCATION);
        try {
            Object obj = instance.getInstance();
            loc.logT(200, "Removing object: " + obj);
            if (obj instanceof EJBObject) {
                ((EJBObject)obj).remove();
            }
        }
        catch (Exception e) {
            loc.catching("Exception in removing session object: [" + instance.getInstance() + "]", (Throwable)e);
        }
    }
}

