/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.interfaces.webservices.runtime.EventObject;
import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.interfaces.webservices.runtime.ImplementationContainer;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ParameterNode;
import com.sap.engine.interfaces.webservices.runtime.ProtocolContext;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.component.ComponentInstantiationException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.time.SystemTime;
import com.sap.engine.library.bytecode.tracing.Tracer;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.ApplicationWebServiceContextImpl;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.runtime.OneWayProcessor;
import com.sap.engine.services.webservices.runtime.ProtocolChainImpl;
import com.sap.engine.services.webservices.runtime.ProtocolChainProcessor;
import com.sap.engine.services.webservices.runtime.ProtocolContextImpl;
import com.sap.engine.services.webservices.runtime.RuntimeContextImpl;
import com.sap.engine.services.webservices.runtime.component.ImplementationContainerManager;
import com.sap.engine.services.webservices.runtime.definition.JavaImplConstants;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.interfaces.RuntimeTransportBinding;
import com.sap.engine.services.webservices.runtime.monitor.WSMonitor;
import com.sap.engine.services.webservices.runtime.monitor.WSRequest;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.tools.ExceptionManager;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;

public final class RuntimeProcessor {
    public static final String JNDI_NAME = "RuntimeProcessor";
    private static InstancesPool runtimeContextPool;
    private static InstancesPool protocolContextPool;
    private static InstancesPool protocolChainPool;
    private static final String EXCEPTION_PROCESSING_LOG = "exception_processing_log";
    private static final String RUNTIME_EXCEPTION_LOG = "runtime_exception_log";
    private static final String ONE_WAY_OPERATION_FEATURE = "http://www.sap.com/webas/630/soap/features/mep/one-way";
    ImplementationContainerManager implementationManager = WSContainer.getImplementationContainerManager();
    ApplicationWebServiceContextImpl threadContextManipulator;
    private static transient /* synthetic */ int t$classId;

    public RuntimeProcessor(ApplicationWebServiceContextImpl manipulator) {
        this.threadContextManipulator = manipulator;
        OneWayProcessor.rtProcessor = this;
        OneWayProcessor.threadSystem = WSContainer.getServiceContext().getCoreContext().getThreadSystem();
    }

    public final void process(Transport transport) throws Exception {
        this.process(transport, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(Transport transport, Hashtable hashtable) throws Exception {
        Tracer.methodStart((int)t$classId, (int)0, (Object)this, (Object[])new Object[]{transport, hashtable});
        try {
            long prePrcssStart = 0L;
            long prePrcssEndImplStart = 0L;
            long implPrcssEndPostPrcssStart = 0L;
            long postPrcssEnd = 0L;
            RuntimeContextImpl context = null;
            ImplementationContainer implContainer = null;
            ClassLoader implLoader = null;
            boolean isFaultBuild = false;
            ServiceEndpointDefinition definition = null;
            WSRequest requestMonitor = null;
            try {
                void metaData;
                void transport2;
                definition = WSContainer.getRuntimeRegistry().getServiceEndpoint(transport2.getEntryPointID());
                boolean beMeasured = WSContainer.isMonitorServiceStarted();
                if (beMeasured) {
                    prePrcssStart = SystemTime.currentTimeStamp();
                }
                context = this.initilizeRuntimeContextInstance(definition, (Hashtable)metaData);
                context.requestMonitor = requestMonitor = WSMonitor.startRequest(definition);
                context.beMeasured = beMeasured;
                context.prePrcssStart = prePrcssStart;
                context.transport = transport2;
                context.transportBinding = this.getTransportBindingInstance(definition);
                this.threadContextManipulator.attachRuntimeContext(context);
                context.transportBinding.setRuntimeContext(context);
                context.transportBinding.setGlobalConfiguration(definition.getTrBindingConfig());
                context.transportBinding.setMappingRegistries(context.javaToQNameMappingRegistry, context.typeMappingRegistry);
                context.transportBinding.setTransport((Transport)transport2);
                if (!ProtocolChainProcessor.protocolsHandleRequest(context)) {
                    context.transportBinding.sendResponse();
                    this.notifyUbnormalProcessing(context, null, this.getLocation(context));
                    requestMonitor.endRequest(false);
                    this.reuseRuntimeContext(context);
                    Object t$returned = null;
                    Tracer.methodEnd((int)t$classId, (int)0, t$returned, null);
                    return;
                }
                OperationDefinition operationDefinition = context.getOperation();
                if (this.isOneWay(operationDefinition)) {
                    new OneWayProcessor().process(context);
                    Object t$returned = null;
                    Tracer.methodEnd((int)t$classId, (int)0, t$returned, null);
                    return;
                }
                context.transportBinding.setVirtualOperation(operationDefinition);
                implContainer = this.implementationManager.getImplementationContainer(context);
                implLoader = implContainer.getImplementationLoader((RuntimeContext)context);
                Class[] paramClasses = RuntimeProcessor.loadParameterClasses(operationDefinition, implLoader);
                Object[] paramObject = context.transportBinding.getParameters(paramClasses, implLoader);
                if (beMeasured) {
                    prePrcssEndImplStart = SystemTime.currentTimeStamp();
                }
                Object result = null;
                try {
                    result = implContainer.invokeMethod(operationDefinition.getJavaOperationName(), paramClasses, paramObject, (RuntimeContext)context);
                }
                catch (InvocationTargetException invE) {
                    this.logImplemException(invE, transport2.getEntryPointID(), context.getLogLocation());
                    context.transportBinding.createFaultMessage(invE.getTargetException());
                    isFaultBuild = true;
                }
                if (beMeasured) {
                    implPrcssEndPostPrcssStart = SystemTime.currentTimeStamp();
                }
                if (!isFaultBuild) {
                    context.transportBinding.createResponseMessage(result, RuntimeProcessor.getReturnClass(operationDefinition, implLoader), paramObject, paramClasses);
                }
                ProtocolChainProcessor.protocolsHandleResponse(context);
                if (context.getEnvironment().getProperty("http://www.sap.com/webas/630/soap/features/java/runtime/send-no-reply") == null) {
                    context.transportBinding.sendResponse();
                }
                if (beMeasured) {
                    postPrcssEnd = SystemTime.currentTimeStamp();
                    requestMonitor.endRequest(true, operationDefinition.getOperationName(), SystemTime.calculateTimeStampDeltaInMicros((long)prePrcssStart, (long)prePrcssEndImplStart), SystemTime.calculateTimeStampDeltaInMicros((long)prePrcssEndImplStart, (long)implPrcssEndPostPrcssStart), SystemTime.calculateTimeStampDeltaInMicros((long)implPrcssEndPostPrcssStart, (long)postPrcssEnd));
                } else {
                    requestMonitor.endRequest(true);
                }
                this.reuseRuntimeContext(context);
            }
            catch (Throwable e) {
                if (requestMonitor != null) {
                    requestMonitor.endRequest(false);
                }
                Location location = this.getLocation(context);
                ExceptionManager.logThrowable((int)300, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"RuntimeProcessor.process()", (Throwable)e);
                this.notifyUbnormalProcessing(context, e, location);
                if (!this.sendError(e, context, location)) {
                    this.reuseRuntimeContext(context);
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                }
                this.reuseRuntimeContext(context);
            }
            Object t$returned = null;
            Tracer.methodEnd((int)t$classId, (int)0, t$returned, null);
            return;
        }
        catch (Throwable t$throwable) {
            void var1_2;
            Tracer.methodEnd((int)t$classId, (int)0, null, (Throwable)t$throwable);
            throw var1_2;
        }
    }

    Location getLocation(RuntimeContextImpl context) {
        Location location = context != null && context.getLogLocation() != null ? context.getLogLocation() : Location.getLocation((String)WSLogging.RUNTIME_LOCATION);
        return location;
    }

    void reuseRuntimeContext(RuntimeContextImpl runtimeContext) {
        if (runtimeContext == null) {
            return;
        }
        ProtocolChainImpl pChain = runtimeContext.protocolChain;
        ProtocolContext[] pContexts = pChain.getProtocolContexts();
        int i = 0;
        while (i < pContexts.length) {
            pContexts[i].clear();
            protocolContextPool.rollBackInstance(pContexts[i]);
            ++i;
        }
        pChain.setProtocolContexts(null);
        protocolChainPool.rollBackInstance(pChain);
        runtimeContext.clear();
        runtimeContextPool.rollBackInstance(runtimeContext);
    }

    public void clearApplicationCaches(String applicationName) {
        this.implementationManager.clearApplicationCaches(applicationName);
    }

    private void notifyUbnormalProcessing(RuntimeContext context, Throwable thr, Location location) {
        EventObject event = new EventObject("http://www.sap.com/webas/630/soap/features/java/implevent/ubnormal-processing", (Object)thr);
        ImplementationContainer implContainer = null;
        try {
            implContainer = this.implementationManager.getImplementationContainer(context);
            implContainer.notify(event, context);
        }
        catch (Exception e) {
            ExceptionManager.logThrowable((int)300, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"RuntimeProcessor.notifyUbnormalProcessing()", (Throwable)e);
        }
    }

    private boolean sendError(Throwable thr, RuntimeContextImpl rntContext, Location location) {
        try {
            rntContext.transportBinding.sendServerError(thr);
            return true;
        }
        catch (Exception trExc) {
            ExceptionManager.logThrowable((int)300, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"RuntimeProcessor.sendError()", (Throwable)trExc);
            return false;
        }
    }

    private final RuntimeContextImpl initilizeRuntimeContextInstance(ServiceEndpointDefinition definition, Hashtable metaData) throws WSWarningException {
        RuntimeContextImpl rc = (RuntimeContextImpl)RuntimeProcessor.initilizeRuntimeContext(definition);
        if (metaData != null) {
            rc.metaData = metaData;
        }
        rc.instanceManager = this.implementationManager;
        return rc;
    }

    public static final RuntimeContext initilizeRuntimeContext(ServiceEndpointDefinition definition) throws WSWarningException {
        Vector<String> warnings = new Vector<String>();
        RuntimeContextImpl runtimeContext = (RuntimeContextImpl)runtimeContextPool.getInstance();
        if (runtimeContext == null) {
            runtimeContext = new RuntimeContextImpl();
        }
        try {
            ProtocolChainImpl protocolChain;
            runtimeContext.protocolChain = protocolChain = RuntimeProcessor.initializeProtocolChain(runtimeContext, definition);
        }
        catch (ComponentInstantiationException e) {
            String msg = "Exception occured during initializing runtime context. Web Service: " + definition.getOwner().getWSIdentifier() + ". WS Configurarion: " + definition.getConfigurationName() + ". ";
            msg = msg + "Unable to initialize protocols chain. ";
            warnings.add(msg);
        }
        runtimeContext.implementationLink = definition.getImplLink();
        runtimeContext.operationRegistry = definition.getOperationMappingRegistry();
        runtimeContext.applicationName = definition.getOwner().getApplicationName();
        runtimeContext.typeMappingRegistry = definition.getOwner().getTypeMappingRegistry();
        runtimeContext.javaToQNameMappingRegistry = definition.getOwner().getJavaToQNameMappingRegistry();
        runtimeContext.wsLocation = definition.getOwner().getWsLocation();
        runtimeContext.wsdName = definition.getOwner().getWsdName();
        runtimeContext.viName = definition.getvInterfaceName();
        runtimeContext.configurationName = definition.getConfigurationName();
        runtimeContext.webServiceName = definition.getOwner().getWSIdentifier().getServiceName();
        runtimeContext.endpointOperations = definition.getOperations();
        if (runtimeContext.implementationLink.getImplId().equals("ejb-impllink")) {
            runtimeContext.securityPolicy = runtimeContext.implementationLink.getProperties().getProperty("application-name") + "*" + definition.getOwner().getWSIdentifier().getJarName();
        } else {
            String endPId = definition.getServiceEndpointId();
            if (endPId.startsWith("/")) {
                endPId = definition.getServiceEndpointId().substring(1);
            }
            endPId = endPId.replace('/', '_').replace('/', '_');
            runtimeContext.securityPolicy = runtimeContext.implementationLink.getProperties().getProperty(JavaImplConstants.APPLICATION_NAME) + "*" + endPId;
        }
        if (definition.isFastEJB()) {
            runtimeContext.environmentProperties.setProperty("http://www.sap.com/webas/630/soap/features/fast-ejb", "true");
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
        return runtimeContext;
    }

    private static final ProtocolChainImpl initializeProtocolChain(RuntimeContextImpl runtimeContext, ServiceEndpointDefinition definition) throws ComponentInstantiationException {
        Hashtable protocolsFeatures = definition.getProtocolIDFeatureMappings();
        String[] protocolIDsOrder = definition.getOrderedProtocolIDs();
        if (protocolIDsOrder == null) {
            protocolIDsOrder = new String[]{};
        }
        ProtocolContext[] orderedContexts = new ProtocolContext[protocolIDsOrder.length];
        int i = 0;
        while (i < protocolIDsOrder.length) {
            ProtocolContextImpl tmpPContext = (ProtocolContextImpl)protocolContextPool.getInstance();
            if (tmpPContext == null) {
                tmpPContext = new ProtocolContextImpl();
            }
            tmpPContext.setRuntimeContext(runtimeContext);
            tmpPContext.setProtocolInstance(WSContainer.getComponentFactory().getProtocolInstance(protocolIDsOrder[i]));
            tmpPContext.getProtocolInstance().init();
            tmpPContext.setGlobalFeatures((Feature[])protocolsFeatures.get(protocolIDsOrder[i]));
            orderedContexts[i] = tmpPContext;
            ++i;
        }
        ProtocolChainImpl pChain = (ProtocolChainImpl)protocolChainPool.getInstance();
        if (pChain == null) {
            pChain = new ProtocolChainImpl(orderedContexts);
        } else {
            pChain.setProtocolContexts(orderedContexts);
        }
        return pChain;
    }

    private final RuntimeTransportBinding getTransportBindingInstance(ServiceEndpointDefinition definition) throws Exception {
        String transportBindingId = definition.getTransportBindingId();
        return (RuntimeTransportBinding)WSContainer.getComponentFactory().getTransportBindingInstance(transportBindingId);
    }

    public static Class[] loadParameterClasses(OperationDefinition operation, ClassLoader implLoader) throws ClassNotFoundException {
        ParameterNode[] params = operation.getInputParameters();
        Class[] result = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            result[i] = RuntimeProcessor.loadClass(params[i].getOriginalClassName(), implLoader);
            ++i;
        }
        return result;
    }

    public static Class getReturnClass(OperationDefinition operation, ClassLoader loader) throws ClassNotFoundException {
        ParameterNode[] outParams = operation.getOutputParameters();
        if (outParams == null || outParams.length == 0) {
            return Void.TYPE;
        }
        return RuntimeProcessor.loadClass(outParams[0].getOriginalClassName(), loader);
    }

    private static Class loadClass(String clDecl, ClassLoader loader) throws ClassNotFoundException {
        int ind = clDecl.indexOf("[]");
        if (ind == -1) {
            if (clDecl.equals("byte")) {
                return Byte.TYPE;
            }
            if (clDecl.equals("char")) {
                return Character.TYPE;
            }
            if (clDecl.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (clDecl.equals("short")) {
                return Short.TYPE;
            }
            if (clDecl.equals("int")) {
                return Integer.TYPE;
            }
            if (clDecl.equals("float")) {
                return Float.TYPE;
            }
            if (clDecl.equals("long")) {
                return Long.TYPE;
            }
            if (clDecl.equals("double")) {
                return Double.TYPE;
            }
            if (clDecl.equals("void")) {
                return Void.TYPE;
            }
            return loader.loadClass(clDecl);
        }
        int[] arrDim = new int[(clDecl.length() - ind) / 2];
        Class compClass = RuntimeProcessor.loadClass(clDecl.substring(0, ind), loader);
        return Array.newInstance(compClass, arrDim).getClass();
    }

    void logImplemException(InvocationTargetException invE, String entryPoint, Location loc) {
        ExceptionManager.logThrowable((int)300, (Category)LoggingHelper.SYS_SERVER, (Location)loc, (String)"RuntimeProcessor.logImplemException()", (String)("EntryPoint: [" + entryPoint + "]. Implementation exception occurs. " + "Please check implementation container(e.g. EJB) logs for additional information!"), (Throwable)invE.getTargetException());
    }

    private boolean isOneWay(OperationDefinition opD) {
        Feature[] fs = opD.getFeatures();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].getFeatureName().equals(ONE_WAY_OPERATION_FEATURE)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        t$classId = Tracer.register(Class.forName("com.sap.engine.services.webservices.runtime.RuntimeProcessor"), (String)"com.sap.engine.services.webservices.runtime.RuntimeProcessor", (String[])new String[]{"process"}, (String[])new String[]{"(Lcom/sap/engine/interfaces/webservices/runtime/Transport;Ljava/util/Hashtable;)V"});
        runtimeContextPool = new InstancesPool();
        protocolContextPool = new InstancesPool();
        protocolChainPool = new InstancesPool();
    }
}

