/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.OperationNotFoundException;
import com.sap.engine.interfaces.webservices.runtime.ProtocolChain;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.TransportBinding;
import com.sap.engine.interfaces.webservices.runtime.TransportBindingException;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.exceptions.accessors.ServerResourceAccessor;
import com.sap.engine.services.webservices.runtime.ProtocolChainImpl;
import com.sap.engine.services.webservices.runtime.component.ImplementationContainerManager;
import com.sap.engine.services.webservices.runtime.interfaces.RuntimeTransportBinding;
import com.sap.engine.services.webservices.runtime.monitor.WSRequest;
import com.sap.engine.services.webservices.runtime.registry.OperationMappingRegistry;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.rpc.encoding.TypeMappingRegistry;

final class RuntimeContextImpl
implements RuntimeContext {
    Hashtable metaData;
    Properties environmentProperties = new Properties();
    RuntimeTransportBinding transportBinding;
    OperationDefinition operation;
    Transport transport;
    ProtocolChainImpl protocolChain;
    String sessionID;
    int sessionTimeout = -1;
    ImplementationContainerManager instanceManager;
    String securityPolicy;
    String applicationName;
    TypeMappingRegistry typeMappingRegistry;
    JavaToQNameMappingRegistry javaToQNameMappingRegistry;
    OperationMappingRegistry operationRegistry;
    ImplLink implementationLink;
    Location wsLocation;
    String wsdName;
    String viName;
    String configurationName;
    String webServiceName;
    WSRequest requestMonitor;
    OperationDefinition[] endpointOperations;
    boolean beMeasured;
    long prePrcssStart;

    RuntimeContextImpl() {
        this.metaData = new Hashtable();
    }

    RuntimeContextImpl(RuntimeTransportBinding trb) {
        this();
        this.transportBinding = trb;
    }

    public String getTargetApplicationName() {
        return this.applicationName;
    }

    public ImplLink getImplementationLink() {
        return this.implementationLink;
    }

    public void setSessionID(String id) {
        if (id == null) {
            throw new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter((ResourceAccessor)ServerResourceAccessor.getResourceAccessor(), "webservices_2017", new Object[]{"ID", id}));
        }
        this.sessionID = id;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void invalidateSession(String sessionID) {
        this.instanceManager.invalidateSession(this, sessionID);
    }

    public String getSecurityPolicy() {
        return this.securityPolicy;
    }

    public Hashtable getMetaData() {
        return this.metaData;
    }

    public void setSessionTimeout(int seconds) {
        this.sessionTimeout = seconds;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public TransportBinding getRuntimeTransportBinding() {
        return this.transportBinding;
    }

    public Properties getEnvironment() {
        return this.environmentProperties;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public OperationDefinition getOperation() throws TransportBindingException, OperationNotFoundException {
        if (this.operation != null) {
            return this.operation;
        }
        Key[] keys = this.transportBinding.getMessageKeys();
        ArrayList operations = this.operationRegistry.getOperations(keys);
        if (operations.size() != 1) {
            String opSize = Integer.toString(operations.size());
            String keysArray = this.kyesToString(keys);
            OperationNotFoundException e = new OperationNotFoundException("Found " + opSize + " operation definitions using keys: " + keysArray);
            Location loc = this.getLogLocation();
            loc.logT(200, "RuntimeContext [getOperation()]", "[OperationRegistry: " + this.operationRegistry + "]");
            LoggingHelper.traceThrowable((int)200, (Location)loc, (String)"RuntimeContext [getOperation()]", (Throwable)e);
            throw e;
        }
        this.operation = (OperationDefinition)operations.get(0);
        return this.operation;
    }

    public ProtocolChain getProtocolChain() {
        return this.protocolChain;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public JavaToQNameMappingRegistry getJavaToQNameRegistry() {
        return this.javaToQNameMappingRegistry;
    }

    public String getWSDName() {
        return this.wsdName;
    }

    public String getVIName() {
        return this.viName;
    }

    public Location getLogLocation() {
        if (this.wsLocation == null) {
            this.wsLocation = Location.getLocation((String)WSLogging.RUNTIME_LOCATION);
        }
        return this.wsLocation;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getWebServiceName() {
        return this.webServiceName;
    }

    public OperationDefinition[] listEndpointOperations() {
        return this.endpointOperations;
    }

    public void clear() {
        this.transportBinding = null;
        this.operationRegistry = null;
        this.implementationLink = null;
        this.operation = null;
        this.sessionID = null;
        ((Hashtable)this.environmentProperties).clear();
        this.metaData.clear();
        this.sessionTimeout = -1;
        this.securityPolicy = null;
        this.instanceManager = null;
        this.typeMappingRegistry = null;
        this.javaToQNameMappingRegistry = null;
        this.wsLocation = null;
        this.wsdName = null;
        this.viName = null;
        this.transport = null;
        this.applicationName = null;
        this.protocolChain = null;
        this.configurationName = null;
        this.webServiceName = null;
        this.requestMonitor = null;
        this.endpointOperations = null;
        this.beMeasured = false;
    }

    void setProtocolChain(ProtocolChainImpl protocolChain) {
        this.protocolChain = protocolChain;
    }

    private String kyesToString(Key[] keys) {
        if (keys == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < keys.length) {
            result.append(keys[i].toString()).append("; ");
            ++i;
        }
        return result.toString();
    }
}

