/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.interfaces.webservices.runtime.Protocol;
import com.sap.engine.interfaces.webservices.runtime.ProtocolContext;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.services.webservices.runtime.FolderContextImpl;
import com.sap.engine.services.webservices.runtime.RuntimeContextImpl;

class ProtocolContextImpl
extends FolderContextImpl
implements ProtocolContext {
    private RuntimeContext runtimeContext;
    private Protocol protocolInstance;
    private Feature[] globalFeatures;

    ProtocolContextImpl() {
    }

    ProtocolContextImpl(RuntimeContext context) {
        this.runtimeContext = context;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public Protocol getProtocolInstance() {
        return this.protocolInstance;
    }

    public Feature[] getGlobalFeatures() {
        return this.globalFeatures;
    }

    public Feature getGlobalFeature(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException("Feature name could not be 'null'");
        }
        int i = 0;
        while (i < this.globalFeatures.length) {
            if (this.globalFeatures[i].getFeatureName().equals(featureName)) {
                return this.globalFeatures[i];
            }
            ++i;
        }
        return null;
    }

    void setRuntimeContext(RuntimeContextImpl context) {
        this.runtimeContext = context;
    }

    void setProtocolInstance(Protocol protocol) {
        this.protocolInstance = protocol;
    }

    void setGlobalFeatures(Feature[] features) {
        this.globalFeatures = features;
    }

    public void clear() {
        super.clear();
        this.runtimeContext = null;
        this.protocolInstance = null;
        this.globalFeatures = null;
    }
}

