/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.interfaces.webservices.runtime.MessageException;
import com.sap.engine.interfaces.webservices.runtime.ProtocolContext;
import com.sap.engine.interfaces.webservices.runtime.ProtocolException;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;

final class ProtocolChainProcessor {
    ProtocolChainProcessor() {
    }

    static boolean protocolsHandleRequest(RuntimeContext context) throws ProtocolException {
        ProtocolContext[] protocols = context.getProtocolChain().getProtocolContexts();
        int count = 0;
        while (count < protocols.length) {
            try {
                if (!protocols[count].getProtocolInstance().handleRequest(protocols[count])) {
                    ProtocolChainProcessor.protocolsHandleResponseInternal(protocols, count);
                    return false;
                }
            }
            catch (MessageException mE) {
                context.getLogLocation().catching((Throwable)mE);
                ProtocolChainProcessor.invokeFault(protocols[count], protocols, count);
                return false;
            }
            ++count;
        }
        return true;
    }

    static void protocolsHandleResponse(RuntimeContext context) throws ProtocolException {
        ProtocolContext[] respProtocols = context.getProtocolChain().getProtocolContexts();
        ProtocolChainProcessor.protocolsHandleResponseInternal(respProtocols, respProtocols.length - 1);
    }

    private static void protocolsHandleResponseInternal(ProtocolContext[] protocols, int startIndex) throws ProtocolException {
        while (startIndex >= 0) {
            if (!protocols[startIndex].getProtocolInstance().handleResponse(protocols[startIndex])) break;
            --startIndex;
        }
    }

    private static void invokeFault(ProtocolContext protocolContext, ProtocolContext[] protocols, int startIndex) throws ProtocolException {
        while (startIndex >= 0) {
            if (!protocols[startIndex].getProtocolInstance().handleFault(protocolContext)) break;
            --startIndex;
        }
    }
}

