/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.webservices.runtime.ImplementationContainer;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.time.SystemTime;
import com.sap.engine.services.webservices.runtime.ProtocolChainProcessor;
import com.sap.engine.services.webservices.runtime.RuntimeContextImpl;
import com.sap.engine.services.webservices.runtime.RuntimeProcessor;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletResponse;

public class OneWayProcessor
implements Runnable {
    private static final String ONE_WAY_PROCESSING_LOG = "one-way_exception_log";
    static RuntimeProcessor rtProcessor;
    static ThreadSystem threadSystem;
    private RuntimeContextImpl context;

    void process(RuntimeContextImpl context) {
        this.context = context;
        HttpServletResponse response = ((HTTPTransport)context.transport).getResponse();
        response.setStatus(202);
        threadSystem.startThread((Runnable)this, false, true);
    }

    public void run() {
        HTTPTransport transport = (HTTPTransport)this.context.transport;
        boolean isFaultBuild = false;
        long prePrcssEndImplStart = 0L;
        long implPrcssEndPostPrcssStart = 0L;
        long postPrcssEnd = 0L;
        try {
            block10: {
                try {
                    OperationDefinition operation = this.context.getOperation();
                    this.context.transportBinding.setVirtualOperation(operation);
                    ImplementationContainer implContainer = OneWayProcessor.rtProcessor.implementationManager.getImplementationContainer(this.context);
                    ClassLoader implLoader = implContainer.getImplementationLoader((RuntimeContext)this.context);
                    Class[] paramClasses = RuntimeProcessor.loadParameterClasses(operation, implLoader);
                    Object[] paramObject = this.context.transportBinding.getParameters(paramClasses, implLoader);
                    if (this.context.beMeasured) {
                        prePrcssEndImplStart = SystemTime.currentTimeStamp();
                    }
                    Object result = null;
                    try {
                        result = implContainer.invokeMethod(operation.getJavaOperationName(), paramClasses, paramObject, (RuntimeContext)this.context);
                    }
                    catch (InvocationTargetException invE) {
                        rtProcessor.logImplemException(invE, transport.getEntryPointID(), this.context.getLogLocation());
                        this.context.transportBinding.createFaultMessage(invE.getTargetException());
                        isFaultBuild = true;
                    }
                    if (this.context.beMeasured) {
                        implPrcssEndPostPrcssStart = SystemTime.currentTimeStamp();
                    }
                    if (!isFaultBuild) {
                        this.context.transportBinding.createResponseMessage(result, RuntimeProcessor.getReturnClass(operation, implLoader), paramObject, paramClasses);
                    }
                    ProtocolChainProcessor.protocolsHandleResponse(this.context);
                    if (this.context.beMeasured) {
                        postPrcssEnd = SystemTime.currentTimeStamp();
                        this.context.requestMonitor.endRequest(true, operation.getOperationName(), SystemTime.calculateTimeStampDeltaInMicros((long)this.context.prePrcssStart, (long)prePrcssEndImplStart), SystemTime.calculateTimeStampDeltaInMicros((long)prePrcssEndImplStart, (long)implPrcssEndPostPrcssStart), SystemTime.calculateTimeStampDeltaInMicros((long)implPrcssEndPostPrcssStart, (long)postPrcssEnd));
                        break block10;
                    }
                    this.context.requestMonitor.endRequest(true);
                }
                catch (Exception e) {
                    this.context.requestMonitor.endRequest(false);
                    Location loc = rtProcessor.getLocation(this.context);
                    loc.catching("one-way_exception_log EntryPoint: [" + transport.getEntryPointID() + "]", (Throwable)e);
                    Object var17_16 = null;
                    OneWayProcessor.rtProcessor.threadContextManipulator.attachRuntimeContext(null);
                    rtProcessor.reuseRuntimeContext(this.context);
                }
            }
            Object var17_15 = null;
            OneWayProcessor.rtProcessor.threadContextManipulator.attachRuntimeContext(null);
            rtProcessor.reuseRuntimeContext(this.context);
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            OneWayProcessor.rtProcessor.threadContextManipulator.attachRuntimeContext(null);
            rtProcessor.reuseRuntimeContext(this.context);
            throw throwable;
        }
    }
}

