/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.interfaces.webservices.runtime.EventObject;
import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.runtime.ImplementationContainer;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.RuntimeProcessException;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.engine.services.webservices.runtime.InstanceWrapper;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.runtime.ServerRuntimeProcessException;
import com.sap.engine.services.webservices.runtime.SessionTable;
import com.sap.engine.services.webservices.runtime.StatelessTable;
import com.sap.engine.services.webservices.runtime.definition.JavaImplConstants;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class JavaClassImplementationContainer
implements ImplementationContainer {
    private static final String IMPLEMENTATION_ID = JavaImplConstants.JAVA_ID;
    private static final String JAVA_CLASS = "java-class";
    private LoadContext loadContext;
    private SessionTable statefulCache;
    private StatelessTable statelessCache;

    public JavaClassImplementationContainer(ServiceContext serviceContext) {
        this.loadContext = serviceContext.getCoreContext().getLoadContext();
        this.statelessCache = new StatelessTable();
        this.statefulCache = new SessionTable();
    }

    public void registerTimeoutListeners(TimeoutManager timeoutManager) {
    }

    public String getImplementationID() {
        return IMPLEMENTATION_ID;
    }

    public ClassLoader getImplementationLoader(RuntimeContext context) throws RuntimeProcessException {
        String appName = context.getImplementationLink().getProperties().getProperty(JavaImplConstants.APPLICATION_NAME);
        ClassLoader loader = this.loadContext.getClassLoader(appName);
        if (loader == null) {
            throw new ServerRuntimeProcessException("webservices_2022", new Object[]{appName});
        }
        return loader;
    }

    public Object invokeMethod(String methodName, Class[] parameterClasses, Object[] parameters, RuntimeContext context) throws RuntimeProcessException, InvocationTargetException {
        InstanceWrapper wrapper = this.getInstance(context);
        Method method = null;
        try {
            method = wrapper.getInstance().getClass().getMethod(methodName, parameterClasses);
        }
        catch (NoSuchMethodException nmE) {
            this.rollBackInstance(context, wrapper);
            throw new ServerRuntimeProcessException("webservices_2004", new Object[]{methodName, Integer.toString(parameterClasses.length), wrapper.getInstance()}, nmE);
        }
        Object returnObject = null;
        try {
            try {
                context.getLogLocation().logT(200, "JavaClassImplementationContainer [invokeMethod(...)]", "Invoking method '" + method + "'...");
                returnObject = method.invoke(wrapper.getInstance(), parameters);
                context.getLogLocation().logT(200, "JavaClassImplementationContainer [invokeMethod(...)]", "Normal completion of method: " + method);
            }
            catch (IllegalArgumentException illargE) {
                throw new ServerRuntimeProcessException("webservices_2000", new Object[]{illargE.getLocalizedMessage()}, illargE);
            }
            catch (IllegalAccessException illaccE) {
                throw new ServerRuntimeProcessException("webservices_2001", new Object[]{illaccE.getLocalizedMessage()}, illaccE);
            }
            catch (InvocationTargetException invE) {
                LoggingHelper.traceThrowable((int)200, (Location)context.getLogLocation(), (String)("JavaClassImplementationContainer [invokeMethod(...)]: Method '" + method + "' completed with exception."), (Throwable)invE.getTargetException());
                throw invE;
            }
            Object var12_9 = null;
            this.rollBackInstance(context, wrapper);
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            this.rollBackInstance(context, wrapper);
            throw throwable;
        }
        return returnObject;
    }

    public void notify(EventObject event, RuntimeContext context) throws RuntimeProcessException {
        String sessionID;
        if (event.getEventID().equals("http://www.sap.com/webas/630/soap/features/java/implevent/stop-application")) {
            this.clearCaches((String)event.getData());
        } else if (!event.getEventID().equals("http://www.sap.com/webas/630/soap/features/java/implevent/invalidate-session") && event.getEventID().equals("http://www.sap.com/webas/630/soap/features/java/implevent/ubnormal-processing") && (sessionID = context.getSessionID()) != null) {
            this.statefulCache.rollbackInstance(sessionID, null);
        }
    }

    public void clearCaches(String applicationName) {
        String currKey;
        Enumeration keys;
        StatelessTable statelessTable = this.statelessCache;
        synchronized (statelessTable) {
            keys = this.statelessCache.keys();
            while (keys.hasMoreElements()) {
                currKey = (String)keys.nextElement();
                if (!currKey.startsWith(applicationName)) continue;
                this.statelessCache.get(currKey).clear();
            }
        }
        SessionTable sessionTable = this.statefulCache;
        synchronized (sessionTable) {
            keys = this.statefulCache.keys();
            while (keys.hasMoreElements()) {
                currKey = (String)keys.nextElement();
                if (!currKey.startsWith(applicationName)) continue;
                this.statefulCache.removeInstance(currKey);
            }
        }
    }

    private InstanceWrapper getInstance(RuntimeContext runtimeContext) throws ServerRuntimeProcessException {
        ImplLink implLink = runtimeContext.getImplementationLink();
        String className = implLink.getProperties().getProperty(JAVA_CLASS);
        if (className == null) {
            throw new ServerRuntimeProcessException("webservices_2024", new Object[]{JAVA_CLASS, implLink});
        }
        String sessionID = runtimeContext.getSessionID();
        String applicationName = runtimeContext.getImplementationLink().getProperties().getProperty(JavaImplConstants.APPLICATION_NAME);
        if (sessionID == null) {
            return this.useStatelessInstance(applicationName, className, runtimeContext.getLogLocation());
        }
        return this.useStatefulInstance(sessionID, runtimeContext.getTransport(), applicationName, className, runtimeContext.getLogLocation());
    }

    private void rollBackInstance(RuntimeContext runtimeContext, InstanceWrapper instance) throws ServerRuntimeProcessException {
        String sessionID = runtimeContext.getSessionID();
        if (sessionID != null) {
            this.statefulCache.rollbackInstance(sessionID, instance);
        } else {
            this.statelessCache.rollBackInstance(instance);
        }
    }

    private void removeStatefulInstance(RuntimeContext context, String id) {
        ImplLink implLink = context.getImplementationLink();
        String className = implLink.getProperties().getProperty(JAVA_CLASS);
        String appName = context.getImplementationLink().getProperties().getProperty(JavaImplConstants.APPLICATION_NAME);
        String tableID = this.getStatefulCacheKey(appName, className, id);
        this.statefulCache.removeInstance(tableID);
    }

    private InstanceWrapper useStatelessInstance(String applicationName, String implClassName, Location loc) throws ServerRuntimeProcessException {
        InstanceWrapper instanceWrapper = null;
        Object instance = null;
        String cacheKey = this.getStatelessCacheKey(applicationName, implClassName);
        InstancesPool instancePool = this.statelessCache.getPool(cacheKey);
        instanceWrapper = (InstanceWrapper)instancePool.getInstance();
        if (instanceWrapper == null) {
            instance = this.createImplementationInstance(applicationName, implClassName);
            instanceWrapper = new InstanceWrapper(instance, cacheKey, instancePool);
            instanceWrapper.logLocation = loc;
        }
        return instanceWrapper;
    }

    private InstanceWrapper useStatefulInstance(String sessionId, Transport transport, String applicationName, String implClassName, Location loc) throws ServerRuntimeProcessException {
        Object instance = null;
        String cacheKey = this.getStatefulCacheKey(applicationName, implClassName, sessionId);
        InstanceWrapper instanceWrapper = this.statefulCache.getInstance(cacheKey);
        if (instanceWrapper == null) {
            instance = this.createImplementationInstance(applicationName, implClassName);
            instanceWrapper = new InstanceWrapper(instance, cacheKey, null);
            instanceWrapper.logLocation = loc;
            ((HTTPTransport)transport).getRequest().getSession().setAttribute(cacheKey, (Object)this.statefulCache);
            this.statefulCache.registerInstanceInuse(instanceWrapper);
        }
        return instanceWrapper;
    }

    private final Object createImplementationInstance(String applicationName, String className) throws ServerRuntimeProcessException {
        ClassLoader loader = this.loadContext.getClassLoader(applicationName);
        Class<?> implClass = null;
        try {
            implClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException cnfE) {
            throw new ServerRuntimeProcessException("webservices_2023", new Object[]{className, loader}, cnfE);
        }
        Object newObject = null;
        try {
            newObject = implClass.newInstance();
        }
        catch (Exception e) {
            throw new ServerRuntimeProcessException("webservices_2008", new Object[]{e.getLocalizedMessage()}, e);
        }
        return newObject;
    }

    private String getStatelessCacheKey(String applicationName, String implClassName) {
        return applicationName + "/" + implClassName;
    }

    private String getStatefulCacheKey(String applicationName, String implClassName, String sessionId) {
        return applicationName + "/" + implClassName + "/" + sessionId;
    }
}

