/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

public class InstancesPool {
    private static final int INITIAL_SIZE = 8;
    private static final int MAX_SIZE = 64;
    private Object[] data;
    private int maxSize;
    private int size;

    public InstancesPool(int initialSize, int maxSize) {
        if (initialSize < 0 || maxSize < 0 || initialSize > maxSize) {
            throw new IllegalStateException("The parameters must be positive and 'initialSize' > 'maxSize'.");
        }
        this.data = new Object[initialSize];
        this.maxSize = maxSize;
        this.size = 0;
    }

    public InstancesPool() {
        this(8, 64);
    }

    public synchronized Object getInstance() {
        if (this.size == 0) {
            return null;
        }
        Object obj = this.data[--this.size];
        this.data[this.size] = null;
        return obj;
    }

    public synchronized void rollBackInstance(Object obj) {
        if (this.size == this.data.length) {
            if (this.data.length == this.maxSize) {
                return;
            }
            int newLength = this.data.length * 2 > this.maxSize ? this.maxSize : this.data.length * 2;
            Object[] temp = this.data;
            this.data = new Object[newLength];
            System.arraycopy(temp, 0, this.data, 0, temp.length);
        }
        this.data[this.size++] = obj;
    }

    public synchronized void clear() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized Object get(int i) {
        if (i >= this.size || i < 0) {
            throw new ArrayIndexOutOfBoundsException("Current size: " + this.size + ". Found: " + i);
        }
        return this.data[i];
    }

    public synchronized Object remove(int i) {
        if (i >= this.size || i < 0) {
            throw new ArrayIndexOutOfBoundsException("Current size: " + this.size + ". Found: " + i);
        }
        Object oldValue = this.data[i];
        int numMoved = this.size - i - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, i + 1, this.data, i, numMoved);
        }
        this.data[--this.size] = null;
        return oldValue;
    }
}

