/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.interfaces.webservices.runtime.FolderContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;

public class FolderContextImpl
implements FolderContext {
    private FolderContext parent = null;
    private ArrayList subfolders = new ArrayList();
    private String folderName;
    private Hashtable properties = new Hashtable();

    FolderContextImpl() {
    }

    private FolderContextImpl(FolderContext parent) {
        this();
        this.parent = parent;
    }

    public FolderContext getSubFolderContext(String name) {
        int i = 0;
        while (i < this.subfolders.size()) {
            FolderContext tempContext = (FolderContext)this.subfolders.get(i);
            if (tempContext.getContextName().equals(name)) {
                return tempContext;
            }
            ++i;
        }
        return null;
    }

    public void clear() {
        this.properties.clear();
        this.subfolders.clear();
        this.parent = null;
        this.folderName = null;
    }

    public FolderContext createSubFolderContext(String contextName) {
        if (contextName == null || contextName.length() == 0) {
            throw new IllegalArgumentException("Found incorrect context-name value '" + contextName + "'");
        }
        if (contextName.indexOf(File.separator) != -1) {
            throw new IllegalArgumentException("Context name must not contain '" + File.separator + "'");
        }
        if (this.getSubFolderContext(contextName) != null) {
            throw new IllegalArgumentException("Subcontext with name '" + contextName + "' already available");
        }
        FolderContextImpl newContext = new FolderContextImpl(this);
        newContext.folderName = contextName;
        this.subfolders.add(newContext);
        return newContext;
    }

    public FolderContext getParentFolderContext() {
        return this.parent;
    }

    public Hashtable getPropertiesReference() {
        return this.properties;
    }

    public String getContextName() {
        return this.folderName;
    }

    public String getContextPath() {
        if (this.parent == null) {
            return File.separator;
        }
        return this.parent.getContextPath() + this.folderName + File.separator;
    }

    public FolderContext[] getAllSubFolderContexts() {
        return this.subfolders.toArray(new FolderContext[this.subfolders.size()]);
    }

    public static void main(String[] args) throws Exception {
        FolderContextImpl root = new FolderContextImpl();
        FolderContext newContext = root.createSubFolderContext("one").createSubFolderContext("two");
        System.out.println(root.getContextPath());
    }
}

