/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.webservices.runtime.EventObject;
import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.runtime.ImplementationContainer;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.RuntimeProcessException;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.InstanceWrapper;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.runtime.ServerRuntimeProcessException;
import com.sap.engine.services.webservices.runtime.SessionTable;
import com.sap.engine.services.webservices.runtime.StatelessTable;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EJBImplementationContainer
implements ImplementationContainer {
    private static final String IMPLEMENTATION_ID = "ejb-impllink";
    private static final int CACHE_ERRORS = 10;
    private Hashtable contextEnvironment;
    private ServiceContext serviceContext;
    private SessionTable statefulCache;
    private StatelessTable statelessCache;

    public EJBImplementationContainer(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.contextEnvironment = new Hashtable();
        this.contextEnvironment.put("domain", "true");
        this.statelessCache = new StatelessTable();
        this.statefulCache = new SessionTable();
    }

    public void registerTimeoutListeners(TimeoutManager timeoutManager) {
    }

    public String getImplementationID() {
        return IMPLEMENTATION_ID;
    }

    public ClassLoader getImplementationLoader(RuntimeContext context) throws RuntimeProcessException {
        String appName = context.getImplementationLink().getProperties().getProperty("application-name");
        ClassLoader loader = this.serviceContext.getCoreContext().getLoadContext().getClassLoader(appName);
        if (loader == null) {
            throw new ServerRuntimeProcessException("webservices_2022", new Object[]{appName});
        }
        return loader;
    }

    public Object invokeMethod(String methodName, Class[] parameterClasses, Object[] parameters, RuntimeContext context) throws RuntimeProcessException, InvocationTargetException {
        String jndiName;
        ImplLink ejbLink = context.getImplementationLink();
        String sessionType = ejbLink.getProperties().getProperty("ejb-session-type");
        if (sessionType == null) {
            throw new ServerRuntimeProcessException("webservices_2024", new Object[]{"ejb-session-type", ejbLink});
        }
        Method method = null;
        InstanceWrapper wrapper = null;
        if (context.getEnvironment().getProperty("http://www.sap.com/webas/630/soap/features/fast-ejb") != null) {
            jndiName = ejbLink.getProperties().getProperty("ejb-jndi-name-local");
            if (jndiName == null) {
                throw new ServerRuntimeProcessException("webservices_2024", new Object[]{"ejb-jndi-name-local", ejbLink});
            }
            wrapper = this.getInstance(jndiName, sessionType, context);
            try {
                method = wrapper.getInstance().getClass().getMethod(methodName, parameterClasses);
                context.getLogLocation().logT(200, "Local interface will be used to invoke method: " + method);
            }
            catch (NoSuchMethodException nmE) {
                this.rollBackInstance(sessionType, context.getSessionID(), wrapper);
                throw new ServerRuntimeProcessException("webservices_2004", new Object[]{methodName, Integer.toString(parameterClasses.length), wrapper.getInstance()}, nmE);
            }
        }
        jndiName = ejbLink.getProperties().getProperty("ejb-jndi-name");
        if (jndiName == null) {
            throw new ServerRuntimeProcessException("webservices_2024", new Object[]{"ejb-jndi-name", ejbLink});
        }
        wrapper = this.getInstance(jndiName, sessionType, context);
        try {
            method = wrapper.getInstance().getClass().getMethod(methodName, parameterClasses);
            context.getLogLocation().logT(200, "Remote interface will be used to invoke method: " + method);
        }
        catch (NoSuchMethodException nmE) {
            this.rollBackInstance(sessionType, context.getSessionID(), wrapper);
            throw new ServerRuntimeProcessException("webservices_2004", new Object[]{methodName, Integer.toString(parameterClasses.length), wrapper.getInstance()}, nmE);
        }
        Object returnObject = null;
        int counter = 0;
        while (counter < 10) {
            try {
                context.getLogLocation().logT(200, "EJBImplementationContainer [invokeMethod(...)]", "Invoking method '" + method + "'...");
                returnObject = method.invoke(wrapper.getInstance(), parameters);
                context.getLogLocation().logT(200, "EJBImplementationContainer [invokeMethod(...)]", "Normal completion of method: " + method);
                break;
            }
            catch (InvocationTargetException invokE) {
                LoggingHelper.traceThrowable((int)200, (Location)context.getLogLocation(), (String)("EJBImplementationContainer [invokeMethod(...)]: Method '" + method + "' completed with exception."), (Throwable)invokE.getTargetException());
                if (invokE.getTargetException() instanceof NoSuchObjectException) {
                    wrapper = this.getInstance(jndiName, sessionType, context);
                    if (!wrapper.isNew) continue;
                    ++counter;
                    continue;
                }
                this.rollBackInstance(sessionType, context.getSessionID(), wrapper);
                throw invokE;
            }
            catch (IllegalArgumentException illargE) {
                this.rollBackInstance(sessionType, context.getSessionID(), wrapper);
                throw new ServerRuntimeProcessException("webservices_2000", new Object[]{illargE.getLocalizedMessage()}, illargE);
            }
            catch (IllegalAccessException illaccE) {
                this.rollBackInstance(sessionType, context.getSessionID(), wrapper);
                throw new ServerRuntimeProcessException("webservices_2001", new Object[]{illaccE.getLocalizedMessage()}, illaccE);
            }
        }
        if (counter == 10) {
            throw new ServerRuntimeProcessException("webservices_2002", new Object[]{Integer.toString(10)});
        }
        this.rollBackInstance(sessionType, context.getSessionID(), wrapper);
        return returnObject;
    }

    public void notify(EventObject event, RuntimeContext context) throws RuntimeProcessException {
        String sessionID;
        if (event.getEventID().equals("http://www.sap.com/webas/630/soap/features/java/implevent/stop-application")) {
            this.clearCaches((String)event.getData());
        } else if (!event.getEventID().equals("http://www.sap.com/webas/630/soap/features/java/implevent/invalidate-session") && event.getEventID().equals("http://www.sap.com/webas/630/soap/features/java/implevent/ubnormal-processing") && (sessionID = context.getSessionID()) != null) {
            this.statefulCache.rollbackInstance(sessionID, null);
        }
    }

    public void clearCaches(String applicationName) {
        String currKey;
        Enumeration keys;
        StatelessTable statelessTable = this.statelessCache;
        synchronized (statelessTable) {
            keys = this.statelessCache.keys();
            while (keys.hasMoreElements()) {
                currKey = (String)keys.nextElement();
                if (!currKey.startsWith(applicationName)) continue;
                this.statelessCache.get(currKey).clear();
            }
        }
        SessionTable sessionTable = this.statefulCache;
        synchronized (sessionTable) {
            keys = this.statefulCache.keys();
            while (keys.hasMoreElements()) {
                currKey = (String)keys.nextElement();
                if (!currKey.startsWith(applicationName)) continue;
                this.statefulCache.removeInstance(currKey);
            }
        }
    }

    private InstanceWrapper getInstance(String jndiName, String sessionType, RuntimeContext runtimeContext) throws ServerRuntimeProcessException {
        String sessionID = runtimeContext.getSessionID();
        String applicationName = runtimeContext.getImplementationLink().getProperties().getProperty("application-name");
        if (sessionID == null && sessionType.equals("stateful") || sessionID != null && sessionType.equals("stateless")) {
            Object bInstance = this.doLookup(applicationName, jndiName);
            InstanceWrapper instWrap = new InstanceWrapper(bInstance, null, null);
            instWrap.logLocation = runtimeContext.getLogLocation();
            return instWrap;
        }
        if (sessionID != null) {
            return this.useStatefulInstance(sessionID, runtimeContext.getTransport(), applicationName, jndiName, runtimeContext.getLogLocation());
        }
        return this.useStatelessInstance(applicationName, jndiName, runtimeContext.getLogLocation());
    }

    private void rollBackInstance(String sessionType, String sessionID, InstanceWrapper instance) throws ServerRuntimeProcessException {
        if (sessionID == null && sessionType.equals("stateful") || sessionID != null && sessionType.equals("stateless")) {
            if (instance == null) {
                return;
            }
            try {
                ((EJBObject)instance.getInstance()).remove();
            }
            catch (Exception rmE) {
                Location loc = instance.logLocation != null ? instance.logLocation : Location.getLocation((String)WSLogging.RUNTIME_LOCATION);
                loc.catching("Exception in removing EJB [" + instance.getInstance() + "]", (Throwable)rmE);
            }
            return;
        }
        instance.isNew = false;
        if (sessionID != null) {
            this.statefulCache.rollbackInstance(sessionID, instance);
        } else {
            this.statelessCache.rollBackInstance(instance);
        }
    }

    private void removeStatefulInstance(RuntimeContext context, String id) throws ServerRuntimeProcessException {
        ImplLink ejbLink = context.getImplementationLink();
        String jndiName = ejbLink.getProperties().getProperty("ejb-jndi-name");
        String appName = context.getImplementationLink().getProperties().getProperty("application-name");
        if (jndiName == null) {
            throw new ServerRuntimeProcessException("webservices_2024", new Object[]{"ejb-jndi-name", ejbLink});
        }
        String tableID = this.getStatefulCacheKey(appName, jndiName, id);
        this.statefulCache.removeInstance(tableID);
    }

    private InstanceWrapper useStatelessInstance(String applicationName, String jndiName, Location loc) throws ServerRuntimeProcessException {
        InstanceWrapper instanceWrapper = null;
        Object beanInstance = null;
        String cacheKey = this.getStatelessCacheKey(applicationName, jndiName);
        InstancesPool instancePool = this.statelessCache.getPool(cacheKey);
        instanceWrapper = (InstanceWrapper)instancePool.getInstance();
        if (instanceWrapper == null) {
            beanInstance = this.doLookup(applicationName, jndiName);
            instanceWrapper = new InstanceWrapper(beanInstance, cacheKey, instancePool);
            instanceWrapper.logLocation = loc;
        }
        return instanceWrapper;
    }

    private InstanceWrapper useStatefulInstance(String sessionId, Transport transport, String applicationName, String jndiName, Location loc) throws ServerRuntimeProcessException {
        Object beanInstance = null;
        String cacheKey = this.getStatefulCacheKey(applicationName, jndiName, sessionId);
        InstanceWrapper instanceWrapper = this.statefulCache.getInstance(cacheKey);
        if (instanceWrapper == null) {
            beanInstance = this.doLookup(applicationName, jndiName);
            instanceWrapper = new InstanceWrapper(beanInstance, cacheKey, null);
            instanceWrapper.logLocation = loc;
            ((HTTPTransport)transport).getRequest().getSession().setAttribute(cacheKey, (Object)this.statefulCache);
            this.statefulCache.registerInstanceInuse(instanceWrapper);
        }
        return instanceWrapper;
    }

    private final Object doLookup(String applicationName, String jndiName) throws ServerRuntimeProcessException {
        Object beanObject = null;
        Class<?> homeClass = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                ClassLoader applicationClassLoader = this.serviceContext.getCoreContext().getLoadContext().getClassLoader(applicationName);
                Thread.currentThread().setContextClassLoader(applicationClassLoader);
                InitialContext ctx = new InitialContext(this.contextEnvironment);
                Object homeObject = ctx.lookup(jndiName);
                homeClass = homeObject.getClass();
                Method createMethod = homeClass.getMethod("create", null);
                Object object = beanObject = createMethod.invoke(homeObject, null);
                Object var12_13 = null;
                Thread.currentThread().setContextClassLoader(currentLoader);
                return object;
            }
            catch (NamingException nmE) {
                throw new ServerRuntimeProcessException("webservices_2006", new Object[]{jndiName, nmE.getLocalizedMessage()}, nmE);
            }
            catch (Exception e) {
                throw new ServerRuntimeProcessException("webservices_2007", new Object[]{e.getLocalizedMessage()}, e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
    }

    private String getStatelessCacheKey(String applicationName, String jndiName) {
        return applicationName + "/" + jndiName;
    }

    private String getStatefulCacheKey(String applicationName, String jndiName, String sessionId) {
        return applicationName + "/" + jndiName + "/" + sessionId;
    }
}

