/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.outsidein;

import com.sap.engine.boot.FileClassLoader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.BeanHandler;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceHandler;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.OperationInterface;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PortalHandler;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceParam;
import com.sap.engine.services.webservices.outsidein.AdditionalData;
import com.sap.engine.services.webservices.outsidein.VIGenerator;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingRegistryImpl;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.FaultConfigDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.NameDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.OperationConfigurationDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.OutsideInConfiguration;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.OutsideInDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.PropertiesDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.PropertyDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.QNameDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.TrBindingConfigDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.TrBindingDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSConfigurationDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceState;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLImportTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.rpc.encoding.TypeMapping;

public class OutSideInGenerator {
    private static final String RPC = "rpc";
    private static final String DOCUMENT = "document";
    private static final String RPC_ENC = "rpc_enc";
    private static final String USE_ENCODED = "encoded";
    private static final String USE_ATTRIB = "use";
    private static final String STYLE_ATTRIB = "style";
    private static final String NAMESPACE_ATTRIB = "namespace";
    private static final String SOAPACTION_ATTRIB = "soapAction";
    private static final String ENCODINGSTYLE_ATTRIB = "encodingStyle";
    private static final String IS_QUALIFIED = "isQualified";
    private static final String FAULT_ELEMENT_NAME = "fault-element-name";
    private static final String OMIT_PART_WRAPPER = "omit-part-wrapper";
    private static final String JAVA_TO_QNAME_FILE = "java-qname-mapping.xml";
    private static final String WS_DEPLOYMENT_DESCRIPTOR_ROOTTAG = "ws-deployment-descriptor";
    private static final String META_INF_DIR = "META-INF";
    private static final String WSDL_DIR = "wsdl";
    private static final String APPLIATION_XML_DOCTYPE = "<!DOCTYPE application SYSTEM \"http://java.sun.com/dtd/application_1_3.dtd\">";
    private static final String EJB_XML_DOCTYPE = "<!DOCTYPE ejb-jar SYSTEM \"http://java.sun.com/dtd/ejb-jar_2_0.dtd\">";
    private static final Random random = new Random();
    static /* synthetic */ Class class$com$sap$engine$services$webservices$outsidein$VIGenerator;

    public void generate(String xmlDataFile) throws Exception {
        AdditionalData addData = new AdditionalData();
        addData.loadXMLData(xmlDataFile);
        File baseDirF = new File(addData.outputDirPath);
        baseDirF.mkdirs();
        WSDLImportTool wsdlImportTool = new WSDLImportTool();
        wsdlImportTool.setImportFix(true);
        File wsdlDir = new File(baseDirF, WSDL_DIR);
        wsdlDir.mkdirs();
        File[] wsdlImpFiles = wsdlImportTool.downloadWSDL(addData.wsdlFileName, wsdlDir, new Hashtable());
        addData.wsdlFileName = wsdlImpFiles[0].getAbsolutePath();
        InterfaceGenerator generator = new InterfaceGenerator();
        WSDLDOMLoader loader = new WSDLDOMLoader();
        WSDLDefinitions definitions = loader.loadWSDLDocument(addData.wsdlFileName);
        Object intHandler = addData.ejbName == null ? new PortalHandler() : new BeanHandler();
        generator.init(definitions, baseDirF.getAbsolutePath(), addData.packageName, (InterfaceHandler)intHandler, null);
        generator.generateAll(true, true);
        String[] interfaces = generator.environment.getInterfaces();
        System.out.println("OutsideInGen: interfaces======= ");
        generator.environment.printInterfaces();
        if (interfaces.length != 1) {
            throw new Exception("Currently only one interface is supported. Found " + interfaces.length);
        }
        this.saveJavaToSchemaMapping(generator.environment.javaToSchemaMapping, new File(baseDirF, JAVA_TO_QNAME_FILE));
        String interfaceName = interfaces[0];
        OperationInterface[] opData = generator.environment.getInterfaceMethods(interfaceName);
        this.generateDDescriptors(interfaceName, opData, definitions, addData);
        if (intHandler instanceof BeanHandler) {
            this.makeEJBArchives((BeanHandler)intHandler, baseDirF, addData);
        } else {
            File[] files = baseDirF.listFiles();
            File jarFile = new File(baseDirF, addData.webServiceName + ".jar");
            if (jarFile.exists()) {
                jarFile.delete();
            }
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(jarFile));
            try {
                this.makeJar(zout, null, files);
                Object var18_17 = null;
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                zout.close();
                throw throwable;
            }
            zout.close();
            {
            }
        }
    }

    private void makeEJBArchives(BeanHandler handler, File baseDirF, AdditionalData addData) throws Exception {
        ArrayList lst = handler.beans;
        BeanHandler.BeanStruct bS = (BeanHandler.BeanStruct)lst.get(0);
        this.writeEJBXML(bS, addData.ejbName, new File(baseDirF, META_INF_DIR));
        File jarFile = new File(baseDirF, addData.webServiceName + ".jar");
        if (jarFile.exists()) {
            jarFile.exists();
        }
        File[] dirFiles = baseDirF.listFiles();
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(jarFile));
        try {
            this.makeJar(zout, null, dirFiles);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            zout.close();
            throw throwable;
        }
        zout.close();
        File appXmlFile = this.writeApplicationXML(addData.webServiceName, jarFile.getName(), new File(baseDirF, META_INF_DIR));
        File earFile = new File(baseDirF, addData.webServiceName + ".ear");
        if (earFile.exists()) {
            earFile.delete();
        }
        zout = new ZipOutputStream(new FileOutputStream(earFile));
        try {
            this.makeJar(zout, META_INF_DIR, new File[]{appXmlFile});
            this.makeJar(zout, null, new File[]{jarFile});
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            zout.close();
            throw throwable;
        }
        zout.close();
    }

    void generateDDescriptors(String javaClassName, OperationInterface[] opData, WSDLDefinitions def, AdditionalData addData) throws Exception {
        Hashtable<String, OperationInterface> ht = new Hashtable<String, OperationInterface>();
        int i = 0;
        while (i < opData.length) {
            if (ht.put(opData[i].operationName, opData[i]) != null) {
                throw new Exception("Found more than one operations with name: " + opData[i].operationName);
            }
            ++i;
        }
        String style = this.loadAddOperationData(ht, def);
        File baseDirF = new File(addData.outputDirPath);
        FileClassLoader loader = new FileClassLoader(this.getClass().getClassLoader(), "", new File[]{baseDirF}, null);
        Class javaClass = loader.loadClass(javaClassName);
        VIGenerator viGen = new VIGenerator();
        VirtualInterfaceState viState = viGen.generateVirtualInterfaceState(javaClass, opData);
        String viName = this.getPureFileName(addData.viFileName);
        viState.setName(viName);
        VIGenerator.saveVIToFile(viState, new File(baseDirF, addData.viFileName));
        this.saveWSD(viName, new File(baseDirF, addData.wsdFileName));
        WSDeploymentDescriptor wsDDescr = this.createWSDeploymentDescriptor(ht, addData, style);
        File wsDDDir = new File(baseDirF, META_INF_DIR);
        wsDDDir.mkdirs();
        this.saveWSDDToFile(wsDDescr, new File(wsDDDir, "ws-deployment-descriptor.xml"));
    }

    private String getPureFileName(String fileName) {
        int ind = fileName.lastIndexOf(".");
        if (ind != -1) {
            return fileName.substring(0, ind);
        }
        return fileName;
    }

    private void writeEJBXML(BeanHandler.BeanStruct bS, String ejbName, File destDir) throws Exception {
        XMLTokenWriterImpl writer = new XMLTokenWriterImpl();
        FileOutputStream fout = new FileOutputStream(new File(destDir, "ejb-jar.xml"));
        writer.init((OutputStream)fout);
        writer.setIndent(true);
        try {
            writer.writeContent(EJB_XML_DOCTYPE);
            writer.enter("", "ejb-jar");
            writer.enter("", "enterprise-beans");
            writer.enter("", "session");
            writer.enter("", "ejb-name");
            writer.writeContent(ejbName);
            writer.leave();
            writer.enter("", "home");
            writer.writeContent(bS.hname);
            writer.leave();
            writer.enter("", "remote");
            writer.writeContent(bS.iname);
            writer.leave();
            writer.enter("", "ejb-class");
            writer.writeContent(bS.cname);
            writer.leave();
            writer.enter("", "session-type");
            writer.writeContent("Stateless");
            writer.leave();
            writer.enter("", "transaction-type");
            writer.writeContent("Bean");
            writer.leave();
            writer.leave();
            writer.leave();
            writer.leave();
            writer.flush();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fout.close();
            throw throwable;
        }
        fout.close();
    }

    private File writeApplicationXML(String appName, String jarName, File destDir) throws Exception {
        XMLTokenWriterImpl writer = new XMLTokenWriterImpl();
        File outf = new File(destDir, "application.xml");
        FileOutputStream fout = new FileOutputStream(outf);
        writer.init((OutputStream)fout);
        writer.setIndent(true);
        try {
            writer.writeContent(APPLIATION_XML_DOCTYPE);
            writer.enter("", "application");
            writer.enter("", "display-name");
            writer.writeContent(appName);
            writer.leave();
            writer.enter("", "module");
            writer.enter("", "ejb");
            writer.writeContent(jarName);
            writer.leave();
            writer.leave();
            writer.leave();
            writer.flush();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fout.close();
            throw throwable;
        }
        fout.close();
        return outf;
    }

    private void saveWSDDToFile(WSDeploymentDescriptor wsDD, File outputFile) throws Exception {
        XMLTokenWriterImpl writer = new XMLTokenWriterImpl();
        FileOutputStream foutStream = new FileOutputStream(outputFile);
        try {
            writer.init((OutputStream)foutStream);
            writer.setIndent(true);
            SOAPSerializationContext context = new SOAPSerializationContext();
            ClassLoader loader = (class$com$sap$engine$services$webservices$outsidein$VIGenerator == null ? (class$com$sap$engine$services$webservices$outsidein$VIGenerator = OutSideInGenerator.class$("com.sap.engine.services.webservices.outsidein.VIGenerator")) : class$com$sap$engine$services$webservices$outsidein$VIGenerator).getClassLoader();
            TypeMappingRegistryImpl TypeMappingRegistryImpl2 = new TypeMappingRegistryImpl();
            TypeMappingRegistryImpl2.fromXML(loader.getResourceAsStream("com/sap/engine/services/webservices/server/deploy/descriptors/sapwebservices/types.xml"), loader);
            TypeMapping typeMapping = TypeMappingRegistryImpl2.getDefaultTypeMapping();
            context.setTypeMapping(typeMapping);
            writer.enter("", WS_DEPLOYMENT_DESCRIPTOR_ROOTTAG);
            wsDD.serialize((Object)wsDD, (XMLTokenWriter)writer, context);
            writer.flush();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            foutStream.close();
            throw throwable;
        }
        foutStream.close();
    }

    private void saveWSD(String viName, File outputFile) throws Exception {
        XMLTokenWriterImpl writer = new XMLTokenWriterImpl();
        FileOutputStream fstream = new FileOutputStream(outputFile);
        writer.init((OutputStream)fstream);
        writer.setIndent(true);
        try {
            writer.enter("http://xml.sap.com/2002/10/def", "WebServiceDefinition");
            writer.writeAttribute("", "name", this.getPureFileName(outputFile.getName()));
            writer.enter("http://xml.sap.com/2002/10/def", "WebServiceDefinition.VirtualInterfaceReferences");
            writer.enter("http://xml.sap.com/2002/10/def", "VirtualInterfaceReference");
            writer.writeAttribute("", "name", viName);
            writer.leave();
            writer.leave();
            writer.leave();
            writer.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fstream.close();
            throw throwable;
        }
        fstream.close();
    }

    private void saveJavaToSchemaMapping(Hashtable javaToQNameMappings, File fToSave) throws Exception {
        JavaToQNameMappingRegistryImpl regImpl = new JavaToQNameMappingRegistryImpl();
        regImpl.setLiteralMappings(new HashMap(javaToQNameMappings));
        regImpl.setEncodedMappings(new HashMap(javaToQNameMappings));
        regImpl.saveToFile(fToSave);
    }

    private String loadAddOperationData(Hashtable opData, WSDLDefinitions def) throws Exception {
        String style = null;
        int i = 0;
        while (i < def.bindings.size()) {
            WSDLBinding binding = (WSDLBinding)def.bindings.get(i);
            ArrayList bindOperations = binding.getOperations();
            int op = 0;
            while (op < bindOperations.size()) {
                OperationInterface curOperData;
                WSDLBindingOperation curOperation = (WSDLBindingOperation)bindOperations.get(op);
                if (style != null) {
                    String curStyle = this.getOperationStyle(curOperation, binding);
                    if (!style.equals(curStyle)) {
                        throw new Exception("Found operations with different styles: '" + style + "' and '" + curStyle + "'");
                    }
                } else {
                    style = this.getOperationStyle(curOperation, binding);
                }
                if ((curOperData = (OperationInterface)opData.get(curOperation.getName())) == null) {
                    throw new Exception("Cannot find OperationData for operation: " + curOperation.getName() + " from binding: " + binding.getName());
                }
                curOperData.operationName = curOperation.getName();
                if (curOperData.operationRequestNamespace == null) {
                    curOperData.operationRequestNamespace = ((WSDLExtension)curOperation.getInput().getExtensions().get(0)).getAttribute(NAMESPACE_ATTRIB);
                }
                if (curOperData.operationResponseNamespace == null) {
                    curOperData.operationResponseNamespace = ((WSDLExtension)curOperation.getOutput().getExtensions().get(0)).getAttribute(NAMESPACE_ATTRIB);
                }
                curOperData.soapAction = ((WSDLExtension)curOperation.getExtensions().get(0)).getAttribute(SOAPACTION_ATTRIB);
                ++op;
            }
            ++i;
        }
        return style;
    }

    private WSDeploymentDescriptor createWSDeploymentDescriptor(Hashtable opData, AdditionalData addData, String style) throws Exception {
        WSDescriptor wsDescr = new WSDescriptor();
        if (addData.ejbName != null) {
            wsDescr.setEjbNameTemp(addData.ejbName);
        }
        wsDescr.setWebserviceInternalName(addData.webServiceName);
        wsDescr.setStandardNamespaceURI(addData.webServiceTNS);
        wsDescr.setGuid(this.getUID());
        QNameDescriptor qnDesc = new QNameDescriptor();
        qnDesc.setLocalName(addData.webServiceName);
        qnDesc.setNamespaceURI(addData.webServiceTNS);
        wsDescr.setWebserviceName(qnDesc);
        WSConfigurationDescriptor wsConf = new WSConfigurationDescriptor();
        qnDesc = new QNameDescriptor();
        qnDesc.setLocalName(addData.webServiceName);
        qnDesc.setNamespaceURI(addData.webServiceTNS);
        wsConf.setServiceEndpointName(qnDesc);
        wsConf.setWsdlPorttypeName(qnDesc);
        wsConf.setConfigurationName(this.getUID());
        if (addData.ejbName != null) {
            wsConf.setEjbName(addData.ejbName);
        }
        NameDescriptor nd = new NameDescriptor();
        nd.setName(addData.viFileName);
        nd.setPackage("");
        wsConf.setServiceEndpointViRef(nd);
        nd = new NameDescriptor();
        nd.setName(addData.wsdFileName);
        nd.setPackage("");
        wsConf.setWebserviceDefinitionRef(nd);
        TrBindingDescriptor trBindingDescriptor = new TrBindingDescriptor();
        trBindingDescriptor.setName("SOAPHTTP_TransportBinding");
        trBindingDescriptor.setWsdlBindingName(qnDesc);
        wsConf.setTransportBinding(trBindingDescriptor);
        wsConf.setTransportAddress(addData.transportAddress);
        Object[] ops = opData.values().toArray();
        OperationConfigurationDescriptor[] opConfDesc = new OperationConfigurationDescriptor[ops.length];
        int i = 0;
        while (i < ops.length) {
            opConfDesc[i] = this.getOperationConfiguration(style, (OperationInterface)ops[i]);
            ++i;
        }
        wsConf.setOperationConfiguration(opConfDesc);
        OutsideInConfiguration outsideIn = new OutsideInConfiguration();
        outsideIn.setStyle(style);
        wsConf.setOutsideInConfiguration(outsideIn);
        wsDescr.setWsConfiguration(new WSConfigurationDescriptor[]{wsConf});
        OutsideInDescriptor outsideInDescriptor = new OutsideInDescriptor();
        nd = new NameDescriptor();
        nd.setName(JAVA_TO_QNAME_FILE);
        nd.setPackage("");
        outsideInDescriptor.setJavaQnameMappingRef(nd);
        nd = new NameDescriptor();
        nd.setName(new File(addData.wsdlFileName).getName());
        nd.setPackage(WSDL_DIR);
        outsideInDescriptor.setWsdlRef(nd);
        wsDescr.setOutsideInDescriptor(outsideInDescriptor);
        WSDeploymentDescriptor wsDeploymentDescriptor = new WSDeploymentDescriptor();
        wsDeploymentDescriptor.setWebservice(new WSDescriptor[]{wsDescr});
        return wsDeploymentDescriptor;
    }

    private OperationConfigurationDescriptor getOperationConfiguration(String style, OperationInterface opData) throws Exception {
        OperationConfigurationDescriptor opCnfDesc = new OperationConfigurationDescriptor();
        opCnfDesc.setName(opData.operationName);
        PropertiesDescriptor inPropDescr = new PropertiesDescriptor();
        PropertiesDescriptor outPropDescr = new PropertiesDescriptor();
        if (opData.soapAction != null) {
            inPropDescr.setProperty(this.addProperty(SOAPACTION_ATTRIB, opData.soapAction, inPropDescr.getProperty()));
        }
        if (opData.isDocumentStyle) {
            outPropDescr.setProperty(this.addProperty(OMIT_PART_WRAPPER, Boolean.TRUE.toString(), outPropDescr.getProperty()));
            inPropDescr.setProperty(this.addProperty(OMIT_PART_WRAPPER, Boolean.TRUE.toString(), inPropDescr.getProperty()));
        }
        outPropDescr.setProperty(this.addProperty(ENCODINGSTYLE_ATTRIB, "http://schemas.xmlsoap.org/soap/encoding/", outPropDescr.getProperty()));
        inPropDescr.setProperty(this.addProperty(ENCODINGSTYLE_ATTRIB, "http://schemas.xmlsoap.org/soap/encoding/", inPropDescr.getProperty()));
        if (style.equals(DOCUMENT)) {
            outPropDescr.setProperty(this.addProperty(IS_QUALIFIED, opData.outputParams[0].namespace != null && opData.outputParams[0].namespace.length() > 0 ? Boolean.TRUE.toString() : Boolean.FALSE.toString(), outPropDescr.getProperty()));
        }
        inPropDescr.setProperty(this.addProperty(NAMESPACE_ATTRIB, opData.operationRequestNamespace, inPropDescr.getProperty()));
        outPropDescr.setProperty(this.addProperty(NAMESPACE_ATTRIB, opData.operationResponseNamespace, outPropDescr.getProperty()));
        TrBindingConfigDescriptor trBCnf = new TrBindingConfigDescriptor();
        trBCnf.setInput(inPropDescr.getProperty());
        trBCnf.setOutput(outPropDescr.getProperty());
        ArrayList<FaultConfigDescriptor> fList = new ArrayList<FaultConfigDescriptor>();
        int i = 0;
        while (i < opData.faultParams.length) {
            ServiceParam fParam = opData.faultParams[i];
            FaultConfigDescriptor curFDescr = new FaultConfigDescriptor();
            curFDescr.setName(fParam.name);
            curFDescr.setProperty(this.addProperty(FAULT_ELEMENT_NAME, fParam.name, curFDescr.getProperty()));
            curFDescr.setProperty(this.addProperty(NAMESPACE_ATTRIB, fParam.namespace, curFDescr.getProperty()));
            fList.add(curFDescr);
            ++i;
        }
        trBCnf.setFault(fList.toArray(new FaultConfigDescriptor[fList.size()]));
        opCnfDesc.setTransportBindingConfiguration(trBCnf);
        return opCnfDesc;
    }

    private PropertyDescriptor[] addProperty(String propName, String propValue, PropertyDescriptor[] props) {
        PropertyDescriptor[] newProps = new PropertyDescriptor[props.length + 1];
        System.arraycopy(props, 0, newProps, 0, props.length);
        PropertyDescriptor newDescr = new PropertyDescriptor();
        newDescr.setName(propName);
        newDescr.setValue(propValue);
        newProps[props.length] = newDescr;
        return newProps;
    }

    private String getUID() {
        return Long.toString(random.nextLong());
    }

    private String getOperationStyle(WSDLBindingOperation wsdlOp, WSDLBinding binding) throws Exception {
        WSDLExtension inputOpExt;
        WSDLExtension ext = (WSDLExtension)binding.getExtensions().get(0);
        String exURI = ext.getURI();
        if (exURI == null && !exURI.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            throw new Exception("Only soapbinding is supported");
        }
        String style = ext.getAttribute(STYLE_ATTRIB);
        ext = (WSDLExtension)wsdlOp.getExtensions().get(0);
        String string = style = ext.getAttribute(STYLE_ATTRIB) != null ? ext.getAttribute(STYLE_ATTRIB) : style;
        if (style == null) {
            style = DOCUMENT;
        }
        if (style.equals(RPC) && (inputOpExt = (WSDLExtension)wsdlOp.getInput().getExtensions().get(0)).getAttribute(USE_ATTRIB).equals(USE_ENCODED)) {
            style = RPC_ENC;
        }
        return style;
    }

    /*
     * WARNING - void declaration
     */
    private void copy(File source, File dest) throws IOException {
        FileInputStream fin = new FileInputStream(source);
        FileOutputStream fout = new FileOutputStream(dest);
        try {
            int b;
            byte[] buf = new byte[128];
            while ((b = fin.read(buf)) != -1) {
                void var6_6;
                fout.write(buf, 0, (int)var6_6);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fin.close();
            fout.close();
            throw throwable;
        }
        fin.close();
        fout.close();
    }

    /*
     * WARNING - void declaration
     */
    private void makeJar(ZipOutputStream zout, String dirPref, File[] files) throws Exception {
        String pref = dirPref != null ? dirPref + "/" : "";
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.makeJar(zout, pref + files[i].getName(), files[i].listFiles());
            } else {
                int b;
                zout.putNextEntry(new ZipEntry(pref + files[i].getName()));
                FileInputStream in = new FileInputStream(files[i]);
                byte[] arr = new byte[128];
                while ((b = in.read(arr)) != -1) {
                    void var8_8;
                    zout.write(arr, 0, (int)var8_8);
                }
                in.close();
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        OutSideInGenerator gen = new OutSideInGenerator();
        if (args == null || args.length == 0) {
            throw new Exception("Enter path to config file");
        }
        gen.generate(args[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

