/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui.tasks;

import com.sap.engine.interfaces.webservices.uddi.UserAccount;
import com.sap.engine.services.webservices.gui.UDDIServerUsersPage;
import com.sap.engine.services.webservices.gui.WSRuntimeLogical;
import com.sap.engine.services.webservices.gui.tasks.AbstractWSTask;
import com.sap.engine.services.webservices.server.WSManagementInterface;

public class UpdateUDDIUserTask
extends AbstractWSTask {
    private WSManagementInterface mi;
    private UserAccount user;
    private char[] password;
    private UDDIServerUsersPage uddiPage;

    public UpdateUDDIUserTask(WSManagementInterface mi, UserAccount user, char[] password, UDDIServerUsersPage uddiPage) {
        this.mi = mi;
        this.user = user;
        this.uddiPage = uddiPage;
        if (password != null) {
            this.taskName = "Creating new user: " + user.getUsername();
            this.password = password;
        } else {
            this.taskName = "Updating user: " + user.getUsername();
        }
    }

    public void run() {
        try {
            this.mi.updateUDDIUser(this.user, this.password);
            this.status = 0;
        }
        catch (Exception e) {
            this.appendThrowable(null, e);
            this.status = 2;
        }
        WSRuntimeLogical logical = (WSRuntimeLogical)this.uddiPage.getUDDIServerPage().getWSRuntimeView();
        logical.refresh();
    }
}

