/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui.tasks;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.interfaces.webservices.uddi.UserAccount;
import com.sap.engine.interfaces.webservices.uddi4j.UDDIRegistry;
import com.sap.engine.services.webservices.gui.UDDIServerGeneralPage;
import com.sap.engine.services.webservices.gui.UDDIServerPage;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.tasks.AbstractWSTask;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import java.util.Properties;

public class RefreshTask
extends AbstractWSTask {
    private WSManagementInterface mi;
    private WSRuntimeView runtimeView;

    public RefreshTask(WSManagementInterface mi, WSRuntimeView runtimeView) {
        super(5);
        this.mi = mi;
        this.runtimeView = runtimeView;
        this.taskName = "Refreshing Web Services Administration UI";
    }

    private void updateSettings() {
        HTTPProxy httpProxy;
        try {
            httpProxy = this.mi.getHTTPProxy();
        }
        catch (Throwable thr) {
            this.appendThrowable("HTTP Proxy Settings", thr);
            httpProxy = new HTTPProxy();
        }
        this.runtimeView.getSettingsPage().updateProxy(httpProxy);
    }

    private void updateWSPage() {
        WSRuntimeDefinition[] webServices;
        try {
            webServices = this.mi.listWebServices();
        }
        catch (Throwable thr) {
            this.appendThrowable("Web Services List", thr);
            webServices = new WSRuntimeDefinition[]{};
        }
        this.runtimeView.getWSPage().updateWebServicesList(webServices);
    }

    private void updateUDDIClient() {
        UDDIRegistry[] registries;
        try {
            registries = this.mi.getUDDIRegistries();
        }
        catch (Throwable thr) {
            this.appendThrowable("UDDI Registries List", thr);
            registries = new UDDIRegistry[]{};
        }
        this.runtimeView.getUDDIClientPage().updateFields(registries);
    }

    public void updateUDDIServer() {
        UserAccount[] users;
        boolean preloaded;
        Properties configuration;
        try {
            configuration = this.mi.getUDDIServerConfig();
        }
        catch (Throwable thr) {
            this.appendThrowable("UDDI Server Configuration", thr);
            configuration = new Properties();
        }
        UDDIServerPage uddiServerPage = this.runtimeView.getUDDIServerPage();
        UDDIServerGeneralPage generalPage = uddiServerPage.getGeneralPage();
        generalPage.updateConfiguration(configuration);
        try {
            preloaded = this.mi.isCanonicalDataPreloaded();
        }
        catch (Throwable thr) {
            this.appendThrowable("UDDI Server Preloaded Status", thr);
            preloaded = false;
        }
        generalPage.updatePreloadedLabel(preloaded);
        try {
            users = this.mi.getAllUDDIUsers();
        }
        catch (Throwable thr) {
            this.appendThrowable("UDDI Server Users", thr);
            users = new UserAccount[]{};
        }
        uddiServerPage.getUsersPage().updateUsersTree(users);
    }

    private boolean hasUDDIServerRegisterred() {
        boolean hasUDDIServer;
        try {
            hasUDDIServer = this.mi.hasUDDIServerRegisterred();
        }
        catch (Throwable thr) {
            this.appendThrowable("UDDI Server Status", thr);
            hasUDDIServer = false;
        }
        this.runtimeView.setUDDIServerDeployed(hasUDDIServer);
        return hasUDDIServer;
    }

    public void run() {
        boolean hasUDDIServer = this.hasUDDIServerRegisterred();
        this.stepCompleted();
        this.updateSettings();
        this.stepCompleted();
        this.updateWSPage();
        this.stepCompleted();
        this.updateUDDIClient();
        this.stepCompleted();
        if (hasUDDIServer) {
            this.updateUDDIServer();
        }
        this.stepCompleted();
        this.status = this.getAdditionalInfo().length() > 0 ? 2 : 0;
    }
}

