/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui.tasks;

import com.sap.engine.services.webservices.gui.WSSLDPage;
import com.sap.engine.services.webservices.gui.tasks.AbstractWSTask;
import com.sap.engine.services.webservices.runtime.definition.SLDWebService;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import javax.swing.JOptionPane;

public class PublishInSLDTask
extends AbstractWSTask {
    private WSManagementInterface mi;
    private WSRuntimeDefinition def;
    private WSSLDPage sldPage;
    private SLDWebService sldWS;

    public PublishInSLDTask(WSManagementInterface mi, WSRuntimeDefinition def, WSSLDPage sldPage) {
        this.mi = mi;
        this.def = def;
        this.sldPage = sldPage;
        this.taskName = "Publishing Web Service into SLD";
        this.sldWS = def.getSLDWebService();
    }

    public void run() {
        try {
            this.def.setSLDWebService(this.sldWS);
            if (this.mi.existsInSLD(this.def)) {
                this.disableProgress = true;
                if (JOptionPane.showConfirmDialog(this.sldPage, "This name already exists in SLD. Do you want to update the entry with this name?", "Confirm modification", 0) == 1) {
                    this.status = 0;
                    return;
                }
                this.disableProgress = false;
            }
            this.mi.publishWSInSLD(this.def);
            this.status = 0;
        }
        catch (Throwable thr) {
            this.appendThrowable(null, thr);
            this.status = 2;
        }
    }
}

