/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui.tasks;

import com.sap.engine.services.webservices.gui.WSProxyPage;
import com.sap.engine.services.webservices.gui.helper.WSTableModel;
import com.sap.engine.services.webservices.gui.tasks.AbstractWSTask;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class GetSchemaToJavaMappingTask
extends AbstractWSTask {
    private WSProxyPage wsProxyPage;
    private WSRuntimeDefinition webService;
    private String wsdlStyle;
    private String mainPackage;

    public GetSchemaToJavaMappingTask(WSRuntimeDefinition webService, WSProxyPage wsProxyPage) {
        this.wsProxyPage = wsProxyPage;
        this.webService = webService;
        this.wsdlStyle = wsProxyPage.getWSDLStyle();
        this.mainPackage = wsProxyPage.getPackageName();
        this.taskName = "Getting schema to java mapping for Web Service: " + webService.getWsQName().getLocalPart() + ", style = " + this.wsdlStyle;
    }

    public void run() {
        try {
            WSManagementInterface mi = this.wsProxyPage.getWSPage().getWSRuntimeView().getManagementInterface();
            Properties props = mi.getSchemaToJavaMapping(this.mainPackage, this.webService.getServiceEndpointDefinitions()[0], this.wsdlStyle, true, this.wsProxyPage.getWSPage().getWSRuntimeView().getHost(), this.wsProxyPage.getWSPage().getWSRuntimeView().getPort());
            String[][] data = new String[((Hashtable)props).keySet().size()][2];
            Enumeration enumeration = ((Hashtable)props).keys();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                String uri = enumeration.nextElement().toString();
                String javaPackage = props.getProperty(uri);
                data[i][0] = uri;
                data[i++][1] = javaPackage;
            }
            WSTableModel tableModel = new WSTableModel(data, "Namespace URI", "Java Package");
            tableModel.setEditableColumn(1, true);
            this.wsProxyPage.setURIMappingModel(tableModel);
            this.status = 0;
        }
        catch (Exception e) {
            this.appendThrowable(null, e);
            this.status = 2;
        }
    }
}

