/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui.tasks;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.webservices.gui.WSProxyPage;
import com.sap.engine.services.webservices.gui.tasks.AbstractWSTask;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;

public class GenerateProxyTask
extends AbstractWSTask {
    private WSProxyPage wsProxyPage;
    private WSRuntimeDefinition webService;

    public GenerateProxyTask(WSRuntimeDefinition webService, WSProxyPage wsProxyPage) {
        this.wsProxyPage = wsProxyPage;
        this.webService = webService;
        this.taskName = "Generate Proxy for Web Service: " + webService.getWsQName().getLocalPart();
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        try {
            int l;
            Properties mapping = this.wsProxyPage.getPackageMapping();
            WSManagementInterface mi = this.wsProxyPage.getWSPage().getWSRuntimeView().getManagementInterface();
            SerializableFile serializedJar = mi.sendProxyJar(this.webService, this.wsProxyPage.getWSDLStyle(), this.wsProxyPage.isSAPWSDLSelected(), this.wsProxyPage.getPackageName(), this.wsProxyPage.isCompileSelected(), this.wsProxyPage.isInterfacesOnlySelected(), this.wsProxyPage.isRPCStyleSelected(), this.wsProxyPage.isJAXRPCInterfacesSelected(), this.wsProxyPage.getWSPage().getWSRuntimeView().getHost(), this.wsProxyPage.getWSPage().getWSRuntimeView().getPort(), mapping);
            FileOutputStream out = new FileOutputStream(this.wsProxyPage.getFileLocation());
            ByteArrayInputStream in = new ByteArrayInputStream(serializedJar.getBytes());
            byte[] b = new byte[1024];
            while ((l = in.read(b)) != -1) {
                void var7_8;
                ((OutputStream)out).write(b, 0, (int)var7_8);
            }
            this.status = 0;
        }
        catch (Throwable thr) {
            this.appendThrowable(null, thr);
            this.status = 2;
        }
    }
}

