/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui.tasks;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public abstract class AbstractWSTask
implements Runnable,
TaskItem {
    private static final Location TASK_LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$webservices$gui$tasks$AbstractWSTask == null ? (class$com$sap$engine$services$webservices$gui$tasks$AbstractWSTask = AbstractWSTask.class$("com.sap.engine.services.webservices.gui.tasks.AbstractWSTask")) : class$com$sap$engine$services$webservices$gui$tasks$AbstractWSTask));
    protected int status = 1;
    private double progress = 0.0;
    protected boolean disableProgress = false;
    private StringBuffer message = new StringBuffer();
    private String lineSeparator;
    private double stepPercent = 100.0;
    private int currentStep = 1;
    protected String taskName;
    private boolean isProgressBarRunning = true;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$gui$tasks$AbstractWSTask;

    protected AbstractWSTask() {
        try {
            this.lineSeparator = System.getProperty("line.separator", "\r\n");
        }
        catch (SecurityException se) {
            this.lineSeparator = "\r\n";
        }
    }

    protected AbstractWSTask(int stepsNumber) {
        this();
        this.stepPercent = 100.0 / (double)stepsNumber;
    }

    public final int getStatus() {
        if (this.isProgressBarRunning) {
            return 1;
        }
        return this.status;
    }

    public final int getProgress() {
        if (this.status != 1) {
            this.isProgressBarRunning = false;
            if (this.status == 0) {
                return 100;
            }
            return (int)this.progress;
        }
        if (this.progress >= 100.0) {
            this.status = 0;
        } else if (!this.disableProgress) {
            this.calculate();
        }
        return (int)this.progress;
    }

    private void calculate() {
        double step = (this.stepPercent - this.progress) / this.stepPercent;
        this.progress += step;
    }

    public final String getAdditionalInfo() {
        return this.message.toString();
    }

    protected final void appendThrowable(String msg, Throwable thr) {
        TASK_LOCATION.catching(thr);
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)sw, true);
        thr.printStackTrace(writer);
        String error = sw.toString();
        writer.close();
        if (this.message != null) {
            this.message.append("An exception occurred while updating ");
            this.message.append(msg);
            this.message.append(". The exception is: ");
            this.message.append(this.lineSeparator);
        }
        this.message.append(error);
        this.message.append(this.lineSeparator);
    }

    protected final void stepCompleted() {
        double percent = this.stepPercent * (double)this.currentStep;
        if (percent < this.progress) {
            this.progress = percent;
        }
        ++this.currentStep;
    }

    public final String getName() {
        return this.taskName;
    }

    public abstract void run();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

