/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui.helper;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class WSFileFilter
extends FileFilter {
    private String extension;
    private String description;

    public WSFileFilter(String extension, String description) {
        this.extension = extension;
        this.description = description;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fileName = f.getName();
        int indexOfLastDot = fileName.lastIndexOf(".");
        if (indexOfLastDot == -1 || indexOfLastDot == fileName.length() - 1) {
            return false;
        }
        return this.extension.equalsIgnoreCase(fileName.substring(indexOfLastDot + 1));
    }

    public String getDescription() {
        return this.description;
    }

    public File appendExtension(File originalFile) {
        if (this.accept(originalFile)) {
            return originalFile;
        }
        String filePath = originalFile.getAbsolutePath();
        if (filePath.endsWith("\\") || filePath.endsWith("/")) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        return new File(filePath + "." + this.extension);
    }
}

