/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.services.webservices.gui.UIHelper;
import com.sap.engine.services.webservices.gui.WSPage;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.tasks.PublishInSLDTask;
import com.sap.engine.services.webservices.runtime.definition.SLDWebService;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WSSLDPage
extends JPanel
implements ActionListener {
    private WSPage wsPage;
    private JButton bPublish;
    private JButton bEdit;
    private JButton bCancel;
    private JTextField fName;
    private JTextField fCaption;
    private JTextArea taDescription;
    private JTextField fWSDLLocation;
    private WSRuntimeDefinition webService;

    public WSSLDPage(WSPage wsPage) {
        this.wsPage = wsPage;
        this.setLayout(new GridBagLayout());
        JLabel lName = new JLabel("Unique Name: ");
        this.add((Component)lName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fName = new JTextField();
        this.add((Component)this.fName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        JLabel lCaption = new JLabel("Caption: ");
        this.add((Component)lCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fCaption = new JTextField();
        this.add((Component)this.fCaption, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        JLabel lWSDL = new JLabel("WSDL Location: ");
        this.add((Component)lWSDL, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fWSDLLocation = new JTextField();
        this.add((Component)this.fWSDLLocation, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        JLabel lDescription = new JLabel("Description: ");
        this.add((Component)lDescription, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        JScrollPane descriptionPane = new JScrollPane();
        this.taDescription = new JTextArea();
        descriptionPane.getViewport().add(this.taDescription);
        this.add((Component)descriptionPane, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        this.bEdit = new JButton("Edit");
        this.bEdit.addActionListener(this);
        buttonsPanel.add((Component)this.bEdit, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.bPublish = new JButton("Publish");
        this.bPublish.addActionListener(this);
        buttonsPanel.add((Component)this.bPublish, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        buttonsPanel.add((Component)this.bCancel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)buttonsPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.updateControls(false);
    }

    private void updateControls(boolean edit) {
        this.fName.setEditable(edit);
        this.fCaption.setEditable(edit);
        this.taDescription.setEditable(edit);
        this.fWSDLLocation.setEditable(edit);
        this.bEdit.setVisible(!edit);
        this.bPublish.setVisible(edit);
        this.bCancel.setVisible(edit);
        if (this.webService != null) {
            SLDWebService sldWS = this.webService.getSLDWebService();
            if (sldWS == null && edit) {
                this.fName.setText(UIHelper.wsIDtoSLDName(this.webService.getWSIdentifier()));
                this.fCaption.setText(this.webService.getWsQName().getLocalPart());
                if (this.webService.getWsdDocumentation() != null) {
                    this.taDescription.setText(this.webService.getWsdDocumentation());
                }
                WSRuntimeView runtimeView = this.wsPage.getWSRuntimeView();
                String host = runtimeView.getHost();
                int port = runtimeView.getPort();
                this.fWSDLLocation.setText("http://" + host + ":" + port + this.webService.getServiceEndpointDefinitions()[0].getServiceEndpointId() + "?wsdl");
            } else {
                if (sldWS == null) {
                    sldWS = new SLDWebService();
                }
                this.fName.setText(sldWS.getName());
                this.fCaption.setText(sldWS.getCaption());
                this.taDescription.setText(sldWS.getDescription());
                this.fWSDLLocation.setText(sldWS.getWsdlLocation());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.bPublish)) {
            WSRuntimeView runtimeView = this.wsPage.getWSRuntimeView();
            SLDWebService sldWS = this.webService.getSLDWebService();
            if (sldWS == null) {
                sldWS = new SLDWebService();
            }
            sldWS.setName(this.getName());
            sldWS.setCaption(this.getCaption());
            sldWS.setDescription(this.getDescription());
            sldWS.setWsdlLocation(this.getWSDLLocation());
            this.webService.setSLDWebService(sldWS);
            PublishInSLDTask task = new PublishInSLDTask(runtimeView.getManagementInterface(), this.webService, this);
            runtimeView.getTaskManager().addTask((TaskItem)task);
            Thread thread = new Thread(task);
            thread.start();
            this.updateControls(false);
        } else if (src.equals(this.bEdit)) {
            this.updateControls(true);
        } else if (src.equals(this.bCancel)) {
            this.updateControls(false);
        }
    }

    public void updateFields(WSRuntimeDefinition webService) {
        this.webService = webService;
        this.updateControls(false);
    }

    public String getName() {
        return this.fName.getText().trim();
    }

    public String getCaption() {
        return this.fCaption.getText().trim();
    }

    public String getDescription() {
        return this.taDescription.getText().trim();
    }

    public String getWSDLLocation() {
        return this.fWSDLLocation.getText().trim();
    }
}

