/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.interfaces.webservices.uddi4j.UDDIRegistry;
import com.sap.engine.services.adminadapter.gui.AdminConfig;
import com.sap.engine.services.webservices.gui.ImageHolder;
import com.sap.engine.services.webservices.gui.SettingsPage;
import com.sap.engine.services.webservices.gui.UDDIClientPage;
import com.sap.engine.services.webservices.gui.UDDIServerPage;
import com.sap.engine.services.webservices.gui.WSPage;
import com.sap.engine.services.webservices.gui.WSRuntimeLogical;
import com.sap.engine.services.webservices.gui.tasks.GetHTTPStartURITask;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;

public abstract class WSRuntimeView
extends JPanel
implements VisualRuntimeControl,
ActionListener {
    public static final JPanel EMPTY_PANEL = new JPanel();
    public static final String[] LOG_TABLE_COLUMNS = new String[]{"Thread", "Severity", "Time", "Message"};
    private JButton refreshButton = new JButton(ImageHolder.refresh);
    protected Frame frame;
    protected JTree wsTree;
    protected JTabbedPane tabbedPane;
    protected WSPage wsPage;
    protected UDDIClientPage uddiClientPage;
    protected UDDIServerPage uddiServerPage;
    protected SettingsPage settingsPage;
    private String httpHost = null;
    private int httpPort = -1;

    protected void init() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(3);
        this.wsPage = new WSPage(this);
        this.tabbedPane.addTab("Web Services", this.wsPage);
        this.settingsPage = new SettingsPage(this);
        this.tabbedPane.addTab("Settings", this.settingsPage);
        this.uddiClientPage = new UDDIClientPage(this);
        this.tabbedPane.addTab("UDDI Client", this.uddiClientPage);
        this.uddiServerPage = new UDDIServerPage(this);
        this.tabbedPane.addTab("UDDI Server", this.uddiServerPage);
        this.setUDDIServerDeployed(false);
        this.add((Component)this.tabbedPane, "Center");
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setToolTipText("Refresh");
        this.refreshButton.addActionListener(this);
    }

    public void setUDDIServerDeployed(boolean isUDDIServerDeployed) {
        this.tabbedPane.setEnabledAt(3, isUDDIServerDeployed);
    }

    public boolean openURLInBrowser(String url) {
        AdminConfig config = AdminConfig.getInstance();
        String browserName = config.getString("ui.browser.FileName");
        String[] cmdarray = new String[]{browserName, url};
        try {
            if (cmdarray[0] == null || cmdarray[0].trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "The browser is not specified! You can specify it from Tools->Properties.", "The browser is not specified", 0);
                return false;
            }
            Runtime.getRuntime().exec(cmdarray);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.toString(), null, 0);
            return false;
        }
        return true;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void freeResources() {
    }

    public abstract WSManagementInterface getManagementInterface();

    public abstract EditorViewManager getTaskManager();

    public String getHost() {
        if (this.httpHost == null) {
            this.parseHTTPStartURI();
        }
        return this.httpHost;
    }

    public int getPort() {
        if (this.httpPort == -1) {
            this.parseHTTPStartURI();
        }
        return this.httpPort;
    }

    private void parseHTTPStartURI() {
        int index;
        GetHTTPStartURITask taskItem = new GetHTTPStartURITask(this.getManagementInterface());
        this.getTaskManager().addTask((TaskItem)taskItem);
        String httpStartURI = taskItem.execute();
        if (httpStartURI.startsWith("http://")) {
            httpStartURI = httpStartURI.substring(7);
        }
        if ((index = httpStartURI.indexOf(":")) != -1) {
            this.httpHost = httpStartURI.substring(0, index);
            this.httpPort = Integer.parseInt(httpStartURI.substring(index + 1));
        } else {
            this.httpHost = httpStartURI;
            this.httpPort = 80;
        }
    }

    public UDDIRegistry[] getUDDIRegistries() {
        return this.uddiClientPage.getUDDIRegistries();
    }

    public static void main(String[] args) throws Exception {
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        };
        JFrame f = new JFrame();
        f.addWindowListener(l);
        WSRuntimeLogical test = new WSRuntimeLogical();
        f.getContentPane().add("Center", new SettingsPage(null));
        ((Component)f).setSize(1000, 700);
        f.show();
    }

    public SettingsPage getSettingsPage() {
        return this.settingsPage;
    }

    public WSPage getWSPage() {
        return this.wsPage;
    }

    public UDDIClientPage getUDDIClientPage() {
        return this.uddiClientPage;
    }

    public UDDIServerPage getUDDIServerPage() {
        return this.uddiServerPage;
    }

    public JButton[] getRuntimeButtons() {
        return new JButton[]{this.refreshButton};
    }

    public abstract void setTaskManager(EditorViewManager var1);

    public abstract JMenu getRuntimeMenu();

    public abstract JComponent getRuntimeControlComponent();

    public abstract void show(ManagementInterface var1);

    public abstract void setEnvironment(String var1, Object var2) throws UnsupportedEditorException;

    public abstract void actionPerformed(ActionEvent var1);
}

