/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.services.webservices.gui.FileChooser;
import com.sap.engine.services.webservices.gui.UIHelper;
import com.sap.engine.services.webservices.gui.WSPage;
import com.sap.engine.services.webservices.gui.helper.ListItem;
import com.sap.engine.services.webservices.gui.helper.WSFileFilter;
import com.sap.engine.services.webservices.gui.helper.WSTableModel;
import com.sap.engine.services.webservices.gui.tasks.GenerateProxyTask;
import com.sap.engine.services.webservices.gui.tasks.GetSchemaToJavaMappingTask;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;

public class WSProxyPage
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener {
    private JComboBox comboWsdlStyle;
    private JCheckBox cbUseSapWsdl;
    private JTextField fPackageName;
    private JTable tURIMapping;
    private JCheckBox cbCompile;
    private JCheckBox cbInterfaces;
    private JCheckBox cbRPCStyle;
    private JCheckBox cbJAXRPCServiceInterfaces;
    private JTextField fFileLocation;
    private JButton bBrowse;
    private JButton bGenerate;
    private WSPage wsPage;
    private String oldProxyPackage = "proxy";

    public WSProxyPage(WSPage wsPage) {
        this.wsPage = wsPage;
        this.setLayout(new GridBagLayout());
        JPanel wsdlStylePanel = new JPanel();
        wsdlStylePanel.setLayout(new GridBagLayout());
        wsdlStylePanel.add((Component)new JLabel("WSDL Style:"), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.comboWsdlStyle = new JComboBox();
        this.comboWsdlStyle.addItemListener(this);
        wsdlStylePanel.add((Component)this.comboWsdlStyle, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.cbUseSapWsdl = new JCheckBox("Use SAP WSDL", true);
        wsdlStylePanel.add((Component)this.cbUseSapWsdl, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.fPackageName = new JTextField();
        this.fPackageName.getDocument().addDocumentListener(this);
        JPanel mappingsPanel = new JPanel(new BorderLayout());
        mappingsPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Namespace URI to Java Package Mapping"));
        JScrollPane mappinsPane = new JScrollPane();
        this.tURIMapping = new JTable();
        this.tURIMapping.setModel(new WSTableModel(new String[0][2], "Namespace URI", "Java Package"));
        mappinsPane.getViewport().add(this.tURIMapping);
        mappingsPanel.add(mappinsPane);
        this.cbCompile = new JCheckBox("Compile", true);
        this.cbInterfaces = new JCheckBox("Generate Interfaces Only", false);
        this.cbRPCStyle = new JCheckBox("Try Generating RPC Style Proxy", false);
        this.cbJAXRPCServiceInterfaces = new JCheckBox("Try Generating JAX-RPC Service Interfaces", false);
        this.fFileLocation = new JTextField();
        this.bBrowse = new JButton("Browse");
        this.bBrowse.addActionListener(this);
        this.bGenerate = new JButton("Generate");
        this.bGenerate.addActionListener(this);
        int line = 0;
        this.add((Component)wsdlStylePanel, new GridBagConstraints(0, line++, 2, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("Package Name:"), new GridBagConstraints(0, line++, 1, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.fPackageName, new GridBagConstraints(0, line++, 2, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)mappingsPanel, new GridBagConstraints(0, line++, 2, 1, 0.1, 0.1, 18, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.cbCompile, new GridBagConstraints(0, line++, 1, 1, 0.1, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.cbInterfaces, new GridBagConstraints(0, line++, 1, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.cbRPCStyle, new GridBagConstraints(0, line++, 1, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.cbJAXRPCServiceInterfaces, new GridBagConstraints(0, line++, 1, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("Save As:"), new GridBagConstraints(0, line++, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.fFileLocation, new GridBagConstraints(0, line, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.bBrowse, new GridBagConstraints(1, line++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.bGenerate, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
        Object button = e.getSource();
        if (button.equals(this.bBrowse)) {
            FileChooser chooser = new FileChooser();
            chooser.setCurrentDirectory(new File(this.fFileLocation.getText().trim()));
            chooser.setMultiSelectionEnabled(false);
            chooser.addChoosableFileFilter(new WSFileFilter("zip", "ZIP Files"));
            chooser.addChoosableFileFilter(new WSFileFilter("jar", "JAR Files"));
            if (chooser.showSaveDialog(this) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.fFileLocation.setText(selectedFile.getAbsolutePath());
            }
        } else if (button.equals(this.bGenerate)) {
            if (this.fFileLocation.getText().trim().length() > 0) {
                this.generateProxy(this.wsPage.getSelectedWS());
            } else {
                JOptionPane.showMessageDialog(this, "File Location should be specified!", "Save As Filename Missing", 0);
            }
        }
    }

    public void generateProxy(WSRuntimeDefinition webService) {
        GenerateProxyTask taskItem = new GenerateProxyTask(webService, this);
        Thread task = new Thread(taskItem);
        this.wsPage.getWSRuntimeView().getTaskManager().addTask((TaskItem)taskItem);
        task.start();
    }

    public Properties getPackageMapping() {
        Properties mapping = null;
        WSTableModel model = (WSTableModel)this.tURIMapping.getModel();
        if (model.getRowCount() > 0) {
            mapping = new Properties();
            int i = 0;
            while (i < model.getRowCount()) {
                String uri = model.getValueAt(i, 0).toString().trim();
                String packageName = model.getValueAt(i, 1).toString().trim();
                mapping.setProperty(uri, packageName);
                ++i;
            }
        }
        return mapping;
    }

    public WSPage getWSPage() {
        return this.wsPage;
    }

    public String getWSDLStyle() {
        ListItem selectedItem = (ListItem)this.comboWsdlStyle.getSelectedItem();
        if (selectedItem == null) {
            return "";
        }
        return selectedItem.getValue().toString();
    }

    public boolean isSAPWSDLSelected() {
        return this.cbUseSapWsdl.isSelected();
    }

    public String getPackageName() {
        return this.fPackageName.getText().trim();
    }

    public boolean isCompileSelected() {
        return this.cbCompile.isSelected();
    }

    public boolean isInterfacesOnlySelected() {
        return this.cbInterfaces.isSelected();
    }

    public boolean isRPCStyleSelected() {
        return this.cbRPCStyle.isSelected();
    }

    public boolean isJAXRPCInterfacesSelected() {
        return this.cbJAXRPCServiceInterfaces.isSelected();
    }

    public String getFileLocation() {
        return this.fFileLocation.getText().trim();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            WSRuntimeDefinition webService = this.wsPage.getSelectedWS();
            this.updateSchemaToJavaMapping(webService);
        }
    }

    public void setURIMappingModel(TableModel tableModel) {
        this.tURIMapping.setModel(tableModel);
    }

    private void updateSchemaToJavaMapping(WSRuntimeDefinition webService) {
        GetSchemaToJavaMappingTask taskItem = new GetSchemaToJavaMappingTask(webService, this);
        Thread task = new Thread(taskItem);
        this.wsPage.getWSRuntimeView().getTaskManager().addTask((TaskItem)taskItem);
        task.start();
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        String mainPackage = this.fPackageName.getText().trim();
        WSTableModel model = (WSTableModel)this.tURIMapping.getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            String packageName = model.getValueAt(i, 1).toString().trim();
            if (packageName.startsWith(this.oldProxyPackage + ".") || packageName.equals(this.oldProxyPackage)) {
                model.setValueAt(mainPackage + packageName.substring(this.oldProxyPackage.length()), i, 1);
            }
            ++i;
        }
        this.tURIMapping.tableChanged(null);
        this.oldProxyPackage = mainPackage;
    }

    public void updateFields(WSRuntimeDefinition webService) {
        this.comboWsdlStyle.removeItemListener(this);
        this.comboWsdlStyle.removeAllItems();
        String[][] styles = UIHelper.getAllWSDLStyles(webService);
        int i = 0;
        while (i < styles.length) {
            String[] style = styles[i];
            this.comboWsdlStyle.addItem(new ListItem(style[0], style[1]));
            ++i;
        }
        this.fPackageName.setText("proxy");
        this.oldProxyPackage = "proxy";
        this.updateSchemaToJavaMapping(webService);
        this.comboWsdlStyle.addItemListener(this);
    }
}

