/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.services.webservices.gui.WSAddressesPage;
import com.sap.engine.services.webservices.gui.WSOverviewPage;
import com.sap.engine.services.webservices.gui.WSProxyPage;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.WSSLDPage;
import com.sap.engine.services.webservices.gui.helper.ListItem;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WSPage
extends JPanel
implements ListSelectionListener {
    private JList wsList;
    private JTabbedPane tabbedPane;
    private WSRuntimeView runtimeView;
    private WSOverviewPage wsOverviewPage;
    private WSProxyPage wsProxyPage;
    private WSAddressesPage wsAddressesPage;
    private WSSLDPage sldPage;

    public WSPage(WSRuntimeView runtimeView) {
        this.runtimeView = runtimeView;
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.wsList = new JList();
        this.wsList.addListSelectionListener(this);
        scrollPane.getViewport().add(this.wsList);
        JPanel wsListPanel = new JPanel();
        wsListPanel.setLayout(new BorderLayout());
        wsListPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Web Services"));
        wsListPanel.add((Component)scrollPane, "Center");
        this.tabbedPane = new JTabbedPane(1);
        this.wsOverviewPage = new WSOverviewPage(this);
        this.tabbedPane.addTab("Overview", this.wsOverviewPage);
        this.wsAddressesPage = new WSAddressesPage(this);
        this.tabbedPane.addTab("Endpoints & WSDL", this.wsAddressesPage);
        this.wsProxyPage = new WSProxyPage(this);
        this.tabbedPane.addTab("Proxy", this.wsProxyPage);
        this.sldPage = new WSSLDPage(this);
        this.tabbedPane.addTab("SLD", this.sldPage);
        this.add((Component)wsListPanel, "West");
        this.add((Component)this.tabbedPane, "Center");
        this.updateEnabledStatus();
    }

    public void updateEnabledStatus() {
        boolean enabled = this.wsList.getModel().getSize() > 0;
        this.tabbedPane.setEnabled(enabled);
        this.wsOverviewPage.updateEnabledStatus(enabled);
        this.wsAddressesPage.updateEnabledStatus(enabled);
    }

    public WSRuntimeDefinition getSelectedWS() {
        ListItem selectedItem = (ListItem)this.wsList.getSelectedValue();
        return (WSRuntimeDefinition)selectedItem.getValue();
    }

    public WSRuntimeView getWSRuntimeView() {
        return this.runtimeView;
    }

    public void updateWebServicesList(WSRuntimeDefinition[] webServices) {
        this.wsList.removeAll();
        ListItem[] items = new ListItem[webServices.length];
        int i = 0;
        while (i < webServices.length) {
            items[i] = new ListItem(webServices[i].getWsQName().getLocalPart(), webServices[i]);
            ++i;
        }
        this.wsList.removeListSelectionListener(this);
        this.wsList.setListData(items);
        this.wsList.addListSelectionListener(this);
        if (items.length > 0) {
            this.wsList.setSelectedIndex(0);
        }
        this.updateEnabledStatus();
    }

    private void updateFields(WSRuntimeDefinition webService) {
        this.wsOverviewPage.updateFields(webService);
        this.wsAddressesPage.updateFields(webService);
        this.wsProxyPage.updateFields(webService);
        this.sldPage.updateFields(webService);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.wsList)) {
            WSRuntimeDefinition webService = this.getSelectedWS();
            this.updateFields(webService);
        }
    }
}

