/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.interfaces.webservices.uddi4j.UDDIRegistry;
import com.sap.engine.services.webservices.gui.ModifyUDDIEntryDlg;
import com.sap.engine.services.webservices.gui.UIHelper;
import com.sap.engine.services.webservices.gui.WSPage;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.helper.WSTableModel;
import com.sap.engine.services.webservices.gui.tasks.MakeRuntimeChangesTask;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.UDDIPublication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class WSOverviewPage
extends JPanel
implements ActionListener {
    private static final String[] UDDI_COLUMNS = new String[]{"Registry", "Service Key", "Registry Inquiry URL", "Registry Publish URL"};
    private static final String UNKNOWN = "Unknown";
    private JTable tUDDI;
    private JButton bPublish;
    private JButton bRemove;
    private JButton bUpdate;
    private JButton bAdd;
    private JLabel lLocationName;
    private JTextArea taWSDDoc;
    private WSPage wsPage;

    public WSOverviewPage(WSPage wsPage) {
        this.wsPage = wsPage;
        this.setLayout(new GridBagLayout());
        JPanel uddiPanel = new JPanel(new GridBagLayout());
        uddiPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "UDDI Publications"));
        JScrollPane uddiPane = new JScrollPane();
        this.tUDDI = new JTable();
        this.tUDDI.setModel(new WSTableModel(new String[0][UDDI_COLUMNS.length], UDDI_COLUMNS));
        ListSelectionModel selecttionModel = this.tUDDI.getSelectionModel();
        selecttionModel.setSelectionMode(0);
        uddiPane.getViewport().add(this.tUDDI);
        this.bPublish = new JButton("Publish");
        this.bPublish.addActionListener(this);
        this.bUpdate = new JButton("Update Publication");
        this.bUpdate.addActionListener(this);
        this.bRemove = new JButton("Remove");
        this.bRemove.addActionListener(this);
        this.bAdd = new JButton("Add Manually");
        this.bAdd.addActionListener(this);
        uddiPanel.add((Component)uddiPane, new GridBagConstraints(0, 0, 4, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
        uddiPanel.add((Component)this.bPublish, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        uddiPanel.add((Component)this.bUpdate, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        uddiPanel.add((Component)this.bRemove, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        uddiPanel.add((Component)this.bAdd, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel locationPanel = new JPanel(new BorderLayout());
        locationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Web Service Location Name"));
        this.lLocationName = new JLabel("");
        locationPanel.add((Component)this.lLocationName, "Center");
        JPanel wsdDocPanel = new JPanel(new BorderLayout());
        wsdDocPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Documentation"));
        JScrollPane wsdPane = new JScrollPane();
        this.taWSDDoc = new JTextArea();
        this.taWSDDoc.setEditable(false);
        wsdPane.getViewport().add(this.taWSDDoc);
        wsdDocPanel.add(wsdPane);
        this.updateButtons();
        this.add((Component)uddiPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)locationPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)wsdDocPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    public void updateEnabledStatus(boolean enabled) {
        if (enabled) {
            this.updateButtons();
        } else {
            this.bPublish.setEnabled(false);
            this.bUpdate.setEnabled(false);
            this.bRemove.setEnabled(false);
            this.bAdd.setEnabled(false);
        }
    }

    private void updateButtons() {
        this.bPublish.setEnabled(true);
        this.bAdd.setEnabled(true);
        boolean hasSelectedEntry = this.tUDDI.getSelectedRow() >= 0;
        this.bUpdate.setEnabled(hasSelectedEntry);
        this.bRemove.setEnabled(hasSelectedEntry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent event) {
        Object button = event.getSource();
        WSRuntimeView runtimeView = this.wsPage.getWSRuntimeView();
        if (JOptionPane.showConfirmDialog(this, "This action will make some runtime changes. If you continue the application may be restarted. You will lose the changes if you redeploy the application later on. Do you want to continue?", "Confirm", 2) != 0) {
            return;
        }
        WSRuntimeDefinition webService = this.wsPage.getSelectedWS();
        if (button.equals(this.bPublish) || button.equals(this.bUpdate)) {
            UDDIPublication[] wsdPublications = webService.getWsdUDDIPublications();
            boolean showConfirm = wsdPublications == null || wsdPublications.length == 0;
            String inquiryURL = null;
            String publishURL = null;
            UDDIRegistry[] registries = this.wsPage.getWSRuntimeView().getUDDIRegistries();
            if (registries.length == 0) {
                JOptionPane.showMessageDialog(this, "No UDDI Registries are configured", "No UDDI Registries are configured", 0);
                return;
            }
            if (button.equals(this.bUpdate)) {
                int row = this.tUDDI.getSelectedRow();
                TableModel tUDDIModel = this.tUDDI.getModel();
                inquiryURL = (String)tUDDIModel.getValueAt(row, 2);
                publishURL = (String)tUDDIModel.getValueAt(row, 3);
                if (inquiryURL == null || inquiryURL.length() == 0) {
                    String key = tUDDIModel.getValueAt(row, 1).toString();
                    ModifyUDDIEntryDlg dlg = new ModifyUDDIEntryDlg(this.wsPage.getWSRuntimeView().getFrame(), registries, key, false);
                    dlg.show();
                    if (dlg.getStatus() != 0) return;
                    UDDIRegistry registry = dlg.getSelectedRegistry();
                    inquiryURL = registry.getInquiryURL();
                    publishURL = registry.getPublishURL();
                    tUDDIModel.setValueAt(inquiryURL, row, 2);
                    tUDDIModel.setValueAt(publishURL, row, 3);
                    this.updateUDDIPublicationsOnServer();
                }
            } else {
                ModifyUDDIEntryDlg dlg = new ModifyUDDIEntryDlg(this.wsPage.getWSRuntimeView().getFrame(), registries, null, true);
                dlg.show();
                if (dlg.getStatus() != 0) return;
                UDDIRegistry registry = dlg.getSelectedRegistry();
                inquiryURL = registry.getInquiryURL();
                publishURL = registry.getPublishURL();
            }
            if (!showConfirm) {
                showConfirm = true;
                int i = 0;
                while (i < wsdPublications.length) {
                    String wsdInquiryURL = wsdPublications[i].getInquiryURL();
                    String wsdPublishURL = wsdPublications[i].getPublishURL();
                    if (wsdInquiryURL == null || inquiryURL.equals(wsdInquiryURL) && publishURL.equals(wsdPublishURL)) {
                        showConfirm = false;
                        break;
                    }
                    ++i;
                }
            }
            if (button.equals(this.bPublish) && showConfirm && JOptionPane.showConfirmDialog(this, "Note that the WSD is not published too and you have to match it manually with an existing InstaceInfo. Are you sure you want to continue?", "Missing WSD tModelKey", 0) == 1) {
                return;
            }
            String host = this.wsPage.getWSRuntimeView().getHost();
            int port = this.wsPage.getWSRuntimeView().getPort();
            String urlToPublish = UIHelper.getPublishInUDDIUrl(webService, host, "" + port, inquiryURL, publishURL);
            runtimeView.openURLInBrowser(urlToPublish);
            return;
        } else if (button.equals(this.bRemove)) {
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the Service Entry from the local repository?", "Removing UDDI Entry", 0) == 1) {
                return;
            }
            UDDIRegistry[] registries = this.wsPage.getWSRuntimeView().getUDDIRegistries();
            UDDIPublication[] publications = this.getUDDIPublications();
            String[][] uddiData = new String[publications.length - 1][UDDI_COLUMNS.length];
            int i = 0;
            int pos = 0;
            while (i < publications.length) {
                if (i != this.tUDDI.getSelectedRow()) {
                    String key = publications[i].getServiceKey();
                    String inquiryURL = publications[i].getInquiryURL();
                    String publishURL = publications[i].getPublishURL();
                    uddiData[pos][0] = this.getRegistryForURLs(inquiryURL, publishURL, registries);
                    uddiData[pos][1] = key;
                    uddiData[pos][2] = inquiryURL != null ? inquiryURL : "";
                    uddiData[pos][3] = publishURL != null ? publishURL : "";
                }
                ++i;
                ++pos;
            }
            this.tUDDI.setModel(new WSTableModel(uddiData, UDDI_COLUMNS));
            if (uddiData.length > 0) {
                this.tUDDI.setRowSelectionInterval(0, 0);
            }
            this.updateButtons();
            this.updateUDDIPublicationsOnServer();
            return;
        } else {
            if (!button.equals(this.bAdd)) return;
            UDDIRegistry[] registries = this.wsPage.getWSRuntimeView().getUDDIRegistries();
            if (registries.length == 0) {
                JOptionPane.showMessageDialog(this, "No UDDI Registries are configured", "No UDDI Registries are configured", 0);
                return;
            }
            ModifyUDDIEntryDlg dlg = new ModifyUDDIEntryDlg(this.wsPage.getWSRuntimeView().getFrame(), registries, null, false);
            dlg.show();
            if (dlg.getStatus() != 0) return;
            UDDIRegistry registry = dlg.getSelectedRegistry();
            UDDIPublication[] publications = this.getUDDIPublications();
            String[][] uddiData = new String[publications.length + 1][UDDI_COLUMNS.length];
            int i = 0;
            while (i < publications.length) {
                String key = publications[i].getServiceKey();
                String inquiryURL = publications[i].getInquiryURL();
                String publishURL = publications[i].getPublishURL();
                uddiData[i][0] = this.getRegistryForURLs(inquiryURL, publishURL, registries);
                uddiData[i][1] = key;
                uddiData[i][2] = inquiryURL != null ? inquiryURL : "";
                uddiData[i][3] = publishURL != null ? publishURL : "";
                ++i;
            }
            int last = publications.length;
            uddiData[last][0] = registry.getName();
            uddiData[last][1] = dlg.getServiceKey();
            uddiData[last][2] = registry.getInquiryURL();
            uddiData[last][3] = registry.getPublishURL();
            this.tUDDI.setModel(new WSTableModel(uddiData, UDDI_COLUMNS));
            this.tUDDI.setRowSelectionInterval(last, last);
            this.updateButtons();
            this.updateUDDIPublicationsOnServer();
        }
    }

    private UDDIPublication[] getUDDIPublications() {
        TableModel tUDDIModel = this.tUDDI.getModel();
        UDDIPublication[] publications = new UDDIPublication[tUDDIModel.getRowCount()];
        int i = 0;
        while (i < publications.length) {
            String key = tUDDIModel.getValueAt(i, 1).toString();
            String inquiryURL = (String)tUDDIModel.getValueAt(i, 2);
            String publishURL = (String)tUDDIModel.getValueAt(i, 3);
            UDDIPublication publication = new UDDIPublication();
            publication.setServiceKey(key);
            if (inquiryURL != null && inquiryURL.length() > 0 && publishURL.length() > 0) {
                publication.setInquiryURL(inquiryURL);
                publication.setPublishURL(publishURL);
            }
            publications[i] = publication;
            ++i;
        }
        return publications;
    }

    private void updateUDDIPublicationsOnServer() {
        WSRuntimeDefinition webService = this.wsPage.getSelectedWS();
        webService.setUddiKey(null);
        webService.setUddiPublications(this.getUDDIPublications());
        WSRuntimeView view = this.wsPage.getWSRuntimeView();
        MakeRuntimeChangesTask task = new MakeRuntimeChangesTask(view.getManagementInterface(), webService);
        Thread thread = new Thread(task);
        view.getTaskManager().addTask((TaskItem)task);
        thread.start();
    }

    private String getRegistryForURLs(String inquiryURL, String publishURL, UDDIRegistry[] registries) {
        int i = 0;
        while (i < registries.length) {
            UDDIRegistry registry = registries[i];
            if (registry.getInquiryURL().equals(inquiryURL) && registry.getPublishURL().equals(publishURL)) {
                return registry.getName();
            }
            ++i;
        }
        return UNKNOWN;
    }

    public void updateFields(WSRuntimeDefinition webService) {
        String uddiKey = webService.getUddiKey();
        UDDIPublication[] uddiPublications = webService.getUddiPublications();
        Vector<String[]> publications = new Vector<String[]>();
        if (uddiKey != null) {
            publications.addElement(new String[]{UNKNOWN, uddiKey, "", ""});
        }
        if (uddiPublications != null) {
            UDDIRegistry[] registries = this.wsPage.getWSRuntimeView().getUDDIRegistries();
            int i = 0;
            while (i < uddiPublications.length) {
                UDDIPublication publication = uddiPublications[i];
                String inquiryURL = publication.getInquiryURL();
                String publishURL = publication.getPublishURL();
                String registry = this.getRegistryForURLs(inquiryURL, publishURL, registries);
                String serviceKey = publication.getServiceKey();
                publications.addElement(new String[]{registry, serviceKey, inquiryURL, publishURL});
                ++i;
            }
        }
        String[][] uddiData = new String[publications.size()][UDDI_COLUMNS.length];
        publications.copyInto((Object[])uddiData);
        this.tUDDI.setModel(new WSTableModel(uddiData, UDDI_COLUMNS));
        if (publications.size() > 0) {
            this.tUDDI.setRowSelectionInterval(0, 0);
        }
        this.updateButtons();
        String locationName = webService.getWSLocationName();
        if (locationName == null) {
            locationName = "Location Name cannot be found";
        }
        this.lLocationName.setText(locationName);
        if (webService.getWsdDocumentation() != null) {
            this.taWSDDoc.setText(webService.getWsdDocumentation());
        } else {
            this.taWSDDoc.setText("Documentation not specified");
        }
    }
}

