/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.services.webservices.gui.UIHelper;
import com.sap.engine.services.webservices.gui.WSPage;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.helper.ListItem;
import com.sap.engine.services.webservices.gui.helper.WSTableModel;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class WSAddressesPage
extends JPanel
implements ActionListener {
    private JTable tTargetAddresses;
    private JButton bOpenTargetAddress;
    private JList lstWSDLs;
    private JCheckBox cbSapWsdl;
    private JButton bOpenWsdl;
    private WSPage wsPage;

    public WSAddressesPage(WSPage wsPage) {
        this.wsPage = wsPage;
        this.setLayout(new GridBagLayout());
        JPanel targetAddressesPanel = new JPanel(new GridBagLayout());
        targetAddressesPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Target Addresses"));
        JScrollPane targetAddressesPane = new JScrollPane();
        this.tTargetAddresses = new JTable();
        this.tTargetAddresses.setModel(new WSTableModel(new String[0][2], "Port Name", "Target Address"));
        targetAddressesPane.getViewport().add(this.tTargetAddresses);
        this.bOpenTargetAddress = new JButton("Open Address In Browser");
        this.bOpenTargetAddress.addActionListener(this);
        targetAddressesPanel.add((Component)targetAddressesPane, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
        targetAddressesPanel.add((Component)this.bOpenTargetAddress, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel wsdlsPanel = new JPanel(new GridBagLayout());
        wsdlsPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "WSDLs"));
        JScrollPane wsdlsPane = new JScrollPane();
        this.lstWSDLs = new JList();
        wsdlsPane.getViewport().add(this.lstWSDLs);
        this.cbSapWsdl = new JCheckBox("SAP WSDL", true);
        this.bOpenWsdl = new JButton("Open WSDL In Browser");
        this.bOpenWsdl.addActionListener(this);
        wsdlsPanel.add((Component)wsdlsPane, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
        wsdlsPanel.add((Component)this.cbSapWsdl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        wsdlsPanel.add((Component)this.bOpenWsdl, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)targetAddressesPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)wsdlsPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    public void updateEnabledStatus(boolean enabled) {
        if (!enabled) {
            this.bOpenTargetAddress.setEnabled(false);
            this.bOpenWsdl.setEnabled(false);
            this.cbSapWsdl.setEnabled(false);
        } else {
            this.updateAddresses();
        }
    }

    public void updateAddresses() {
        boolean enabled = this.tTargetAddresses.getModel().getRowCount() > 0;
        this.bOpenTargetAddress.setEnabled(enabled);
        enabled = this.lstWSDLs.getModel().getSize() > 0;
        this.bOpenWsdl.setEnabled(enabled);
        this.cbSapWsdl.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent event) {
        block5: {
            WSRuntimeView runtimeView;
            Object button;
            block6: {
                button = event.getSource();
                runtimeView = this.wsPage.getWSRuntimeView();
                if (!button.equals(this.bOpenWsdl)) break block6;
                Object[] urls = this.lstWSDLs.getSelectedValues();
                int i = 0;
                while (i < urls.length) {
                    String url = ((ListItem)urls[i]).getValue().toString();
                    if (this.cbSapWsdl.isSelected()) {
                        url = url + "&mode=sap_wsdl";
                    }
                    if (runtimeView.openURLInBrowser(url)) {
                        ++i;
                        continue;
                    }
                    break block5;
                }
                break block5;
            }
            if (!button.equals(this.bOpenTargetAddress)) break block5;
            int[] selectedRows = this.tTargetAddresses.getSelectedRows();
            int i = 0;
            while (i < selectedRows.length) {
                String url = this.tTargetAddresses.getModel().getValueAt(selectedRows[i], 1).toString();
                if (runtimeView.openURLInBrowser(url)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    public void updateFields(WSRuntimeDefinition webService) {
        String hostname = this.wsPage.getWSRuntimeView().getHost();
        int port = this.wsPage.getWSRuntimeView().getPort();
        String[][] wsdls = UIHelper.getAllWSDLStylesAsURLs(webService, hostname, port);
        String[][] targetAddresses = UIHelper.getTargetAddresses(webService, hostname, port);
        this.tTargetAddresses.setModel(new WSTableModel(targetAddresses, "Port Name", "Target Address"));
        if (targetAddresses.length > 0) {
            this.tTargetAddresses.setRowSelectionInterval(0, 0);
        }
        ListItem[] wsdlListItems = new ListItem[wsdls.length];
        int i = 0;
        while (i < wsdlListItems.length) {
            wsdlListItems[i] = new ListItem(wsdls[i][0], wsdls[i][1]);
            ++i;
        }
        this.lstWSDLs.setListData(wsdlListItems);
        if (wsdlListItems.length > 0) {
            this.lstWSDLs.setSelectedIndex(0);
        }
    }
}

