/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import java.net.URLEncoder;

public class UIHelper {
    public static final String SAP_MODE_PARAMETER = "mode=sap_wsdl";
    public static final String WSDL_STYLE_TEXT = "WSDL Style";
    public static final String USE_SAP_STYLE_TEXT = "Use SAP WSDL";
    public static final String PACKAGE_NAME_TEXT = "Package Name";
    public static final String URI_TO_PACKAGE_MAPPING_TEXT = "Namespace URI to Java Package Mapping";
    public static final String COMPILE_TEXT = "Compile";
    public static final String INTERFACES_ONLY_TEXT = "Generate Interfaces Only";
    public static final String RPC_STYLE_TEXT = "Try Generating RPC Style Proxy";
    public static final String JAXRPC_INTERFACES_TEXT = "Try Generating JAX-RPC Service Interfaces";
    public static final String PACKAGE_NAME_NEEDED_TEXT = "A package name must be specified";
    public static final String FILE_LOCATION_TEXT = "Save As";
    public static final String BROWSE_BUTTON_TEXT = "Browse";
    public static final String GENERATE_BUTTON_TEXT = "Generate";
    public static final String SEVERITY_LEVEL_TEXT = "Severity Level";
    public static final String LOGS_LIST_TEXT = "Logs";
    public static final String LOG_TEXT = "Text";
    public static final String SERVICE_NOT_PUBLISHED = "The service is not published, yet";
    public static final String DO_YOU_WANT_TO_SAVE_CHANGES = "This action will make some runtime changes. If you continue the application may be restarted. You will lose the changes if you redeploy the application later on. Do you want to continue?";
    public static final String MISSING_WSD_TMODELKEY = "Note that the WSD is not published too and you have to match it manually with an existing InstaceInfo.";
    public static final String DOCUMENTATION_NOT_SPECIFIED = "Documentation not specified";

    public static String[][] getAllWSDLStylesAsURLs(WSRuntimeDefinition webService, String host, int port) {
        String[][] styles = UIHelper.getAllWSDLStyles(webService);
        String endpointId = webService.getServiceEndpointDefinitions()[0].getServiceEndpointId();
        if (endpointId.startsWith("/")) {
            endpointId = endpointId.substring(1);
        }
        String url = "http://" + host + ":" + port + "/" + endpointId + "?wsdl";
        int i = 0;
        while (i < styles.length) {
            styles[i][1] = styles[i][1].length() > 0 ? url + "&style=" + styles[i][1] : url;
            ++i;
        }
        return styles;
    }

    public static String getSapWsdlFromOriginalUrl(String wsdlURL) {
        StringBuffer buf = new StringBuffer(wsdlURL);
        if (wsdlURL.indexOf("?") == -1) {
            buf.append('?');
        } else {
            buf.append('&');
        }
        buf.append(SAP_MODE_PARAMETER);
        return buf.toString();
    }

    public static String[][] getAllWSDLStyles(WSRuntimeDefinition webService) {
        String[] supportedStyles = webService.getWsdlSupportedStyles();
        String[][] styles = new String[supportedStyles.length + 1][2];
        styles[0][0] = UIHelper.getNameOfStyle("");
        styles[0][1] = "";
        int i = 0;
        while (i < supportedStyles.length) {
            String style = supportedStyles[i];
            styles[i + 1][0] = UIHelper.getNameOfStyle(style);
            styles[i + 1][1] = style;
            ++i;
        }
        return styles;
    }

    public static String getNameOfStyle(String style) {
        if (style.length() == 0) {
            return "Default";
        }
        if ("document".equals(style)) {
            return "Document";
        }
        if ("rpc".equals(style)) {
            return "RPC";
        }
        if ("rpc_document".equals(style)) {
            return "RPC & Document";
        }
        if ("rpc_enc".equals(style)) {
            return "RPC Encoded";
        }
        if ("http".equals(style)) {
            return "HTTP";
        }
        return style;
    }

    public static String getUDDIKey(WSRuntimeDefinition webService) {
        return webService.getUddiKey();
    }

    public static String[][] getTargetAddresses(WSRuntimeDefinition webService, String host, int port) {
        ServiceEndpointDefinition[] endpoints = webService.getServiceEndpointDefinitions();
        String[][] addresses = new String[endpoints.length][2];
        int i = 0;
        while (i < endpoints.length) {
            ServiceEndpointDefinition endpoint = endpoints[i];
            addresses[i][0] = endpoint.getServiceEndpointQualifiedName().getLocalPart();
            String endpointId = endpoint.getServiceEndpointId();
            if (endpointId.startsWith("/")) {
                endpointId = endpointId.substring(1);
            }
            addresses[i][1] = "http://" + host + ":" + port + "/" + endpointId;
            ++i;
        }
        return addresses;
    }

    public static final String getPublishInUDDIUrl(WSRuntimeDefinition webService, String host, String port, String inquiryURL, String publishURL) {
        StringBuffer buf = new StringBuffer("http://" + host + ":" + port + "/uddiclient/tools?action=Service");
        WSIdentifier wsId = webService.getWSIdentifier();
        buf.append("&serviceName=" + URLEncoder.encode(wsId.getServiceName()));
        buf.append("&applicationName=" + URLEncoder.encode(wsId.getApplicationName()));
        buf.append("&jarName=" + URLEncoder.encode(wsId.getJarName()));
        if (inquiryURL != null && publishURL != null) {
            buf.append("&inquiryURL=" + URLEncoder.encode(inquiryURL));
            buf.append("&publishURL=" + URLEncoder.encode(publishURL));
        }
        return buf.toString();
    }

    public static String severityToString(int severity) {
        switch (severity) {
            case 0: {
                return "All";
            }
            case 100: {
                return "Debug";
            }
            case 200: {
                return "Path";
            }
            case 300: {
                return "Info";
            }
            case 400: {
                return "Warning";
            }
            case 500: {
                return "Error";
            }
            case 600: {
                return "Fatal";
            }
            case 701: {
                return "None";
            }
        }
        return "N/A";
    }

    public static String wsIDtoSLDName(WSIdentifier id) {
        return "{" + id.getApplicationName() + "}{" + id.getJarName() + "}{" + id.getServiceName() + "}";
    }
}

