/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.interfaces.webservices.uddi.UserAccount;
import com.sap.engine.services.webservices.gui.UDDIServerPage;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.helper.UDDIUsersRenderer;
import com.sap.engine.services.webservices.gui.tasks.RemoveUserTask;
import com.sap.engine.services.webservices.gui.tasks.UpdateUDDIUserTask;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class UDDIServerUsersPage
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private JLabel lConfirmPassword;
    private JLabel lPassword;
    private JLabel lUsername;
    private JPasswordField fConfirmPassword;
    private JPasswordField fPassword;
    private JTextField fUsername;
    private JComboBox cLanguage;
    private JButton bCancel;
    private JButton bSave;
    private JComboBox cLevel;
    private JTextArea taAddress;
    private JTextField fPhone;
    private JTextField fEmail;
    private JButton bRemoveUser;
    private JButton bEditUser;
    private JButton bNewUser;
    private JTextField fFullName;
    private JTree tUDDIUsers;
    private UDDIServerPage uddiServerPage;
    private Properties languages = new Properties();
    private Properties reversedLanguages = new Properties();
    private Vector sortedLangValues = new Vector();

    public UDDIServerUsersPage(UDDIServerPage uddiServerPage) {
        this.uddiServerPage = uddiServerPage;
        this.setLayout(new GridBagLayout());
        JPanel uddiUsersPanel = new JPanel(new GridBagLayout());
        uddiUsersPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "UDDI Users"));
        JScrollPane usersPane = new JScrollPane();
        this.tUDDIUsers = new JTree();
        this.tUDDIUsers.setCellRenderer(new UDDIUsersRenderer());
        this.tUDDIUsers.getSelectionModel().setSelectionMode(1);
        this.tUDDIUsers.addTreeSelectionListener(this);
        usersPane.getViewport().add(this.tUDDIUsers);
        uddiUsersPanel.add((Component)new JLabel("Active users:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0));
        uddiUsersPanel.add((Component)usersPane, new GridBagConstraints(0, 1, 1, 8, 0.0, 0.1, 18, 1, new Insets(0, 5, 10, 5), 0, 0));
        this.bNewUser = new JButton("New User");
        this.bNewUser.addActionListener(this);
        uddiUsersPanel.add((Component)this.bNewUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.bEditUser = new JButton("Edit User");
        this.bEditUser.addActionListener(this);
        uddiUsersPanel.add((Component)this.bEditUser, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.bRemoveUser = new JButton("Delete User");
        this.bRemoveUser.addActionListener(this);
        uddiUsersPanel.add((Component)this.bRemoveUser, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        JPanel userInfoPanel = new JPanel(new GridBagLayout());
        uddiUsersPanel.add((Component)userInfoPanel, new GridBagConstraints(1, 2, 3, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
        JPanel userPassPanel = new JPanel(new GridBagLayout());
        userInfoPanel.add((Component)userPassPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lUsername = new JLabel("Username:");
        userPassPanel.add((Component)this.lUsername, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.fUsername = new JTextField();
        userPassPanel.add((Component)this.fUsername, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.lPassword = new JLabel("Password:");
        userPassPanel.add((Component)this.lPassword, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.fPassword = new JPasswordField();
        userPassPanel.add((Component)this.fPassword, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.lConfirmPassword = new JLabel("Confirm password:");
        userPassPanel.add((Component)this.lConfirmPassword, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.fConfirmPassword = new JPasswordField();
        userPassPanel.add((Component)this.fConfirmPassword, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        userInfoPanel.add((Component)new JLabel("Full Name:"), new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.fFullName = new JTextField();
        userInfoPanel.add((Component)this.fFullName, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel mailPhonePanel = new JPanel(new GridBagLayout());
        userInfoPanel.add((Component)mailPhonePanel, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        mailPhonePanel.add((Component)new JLabel("E-mail:"), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.fEmail = new JTextField();
        mailPhonePanel.add((Component)this.fEmail, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        mailPhonePanel.add((Component)new JLabel("Phone:"), new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.fPhone = new JTextField();
        mailPhonePanel.add((Component)this.fPhone, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        userInfoPanel.add((Component)new JLabel("Address:"), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        JScrollPane addressPane = new JScrollPane();
        this.taAddress = new JTextArea();
        addressPane.getViewport().add(this.taAddress);
        userInfoPanel.add((Component)addressPane, new GridBagConstraints(0, 5, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel levelLanguagePanel = new JPanel(new GridBagLayout());
        userInfoPanel.add((Component)levelLanguagePanel, new GridBagConstraints(0, 6, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        levelLanguagePanel.add((Component)new JLabel("Level:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.cLevel = new JComboBox<String>(new String[]{"Tier 1", "Tier N", "Admin"});
        levelLanguagePanel.add((Component)this.cLevel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        levelLanguagePanel.add((Component)new JLabel("Language:"), new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        String fullName = "/com/sap/engine/services/webservices/gui/helper/languages.txt";
        InputStream in = this.getClass().getResourceAsStream(fullName);
        if (in != null) {
            this.languages = new Properties();
            try {
                this.languages.load(in);
                in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            Enumeration langCodes = ((Hashtable)this.languages).keys();
            while (langCodes.hasMoreElements()) {
                String code = langCodes.nextElement().toString();
                String value = this.languages.getProperty(code);
                this.reversedLanguages.setProperty(value, code);
                this.sortedLangValues.addElement(value);
            }
            Collections.sort(this.sortedLangValues);
        } else {
            System.err.println("Cannot find resource: " + fullName);
        }
        this.cLanguage = new JComboBox(this.sortedLangValues);
        levelLanguagePanel.add((Component)this.cLanguage, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel saveCancelPanel = new JPanel(new GridBagLayout());
        userInfoPanel.add((Component)saveCancelPanel, new GridBagConstraints(0, 7, 1, 1, 0.1, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.bSave = new JButton("Save");
        this.bSave.addActionListener(this);
        this.bSave.setVisible(false);
        saveCancelPanel.add((Component)this.bSave, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        this.bCancel.setVisible(false);
        saveCancelPanel.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.updateFieldsStatus(false, false, false);
        this.updateUsersTree(new UserAccount[0]);
        this.add((Component)uddiUsersPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 11, 1, new Insets(0, 5, 10, 5), 0, 0));
    }

    private UserAccount getSelectedUser() {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.tUDDIUsers.getSelectionPath().getLastPathComponent();
        return (UserAccount)treeNode.getUserObject();
    }

    private void updateFieldsStatus(boolean userIsSelected, boolean editMode, boolean newUser) {
        this.bNewUser.setEnabled(!editMode);
        this.bEditUser.setEnabled(userIsSelected && !editMode);
        this.bRemoveUser.setEnabled(userIsSelected && !editMode);
        this.fFullName.setEditable(editMode);
        this.fEmail.setEditable(editMode);
        this.fPhone.setEditable(editMode);
        this.taAddress.setEditable(editMode);
        this.cLevel.setEnabled(editMode);
        this.cLanguage.setEnabled(editMode);
        this.bSave.setVisible(editMode);
        this.bCancel.setVisible(editMode);
        this.tUDDIUsers.setEnabled(!editMode);
        this.lUsername.setVisible(newUser);
        this.fUsername.setVisible(newUser);
        this.lPassword.setVisible(newUser);
        this.fPassword.setVisible(newUser);
        this.lConfirmPassword.setVisible(newUser);
        this.fConfirmPassword.setVisible(newUser);
        if (userIsSelected && !newUser) {
            UserAccount user = this.getSelectedUser();
            this.fFullName.setText(user.getFullName());
            this.fEmail.setText(user.getEmail());
            this.fPhone.setText(user.getPhone());
            this.taAddress.setText(user.getAddress());
            switch (user.getLevel()) {
                case 3: {
                    this.cLevel.setSelectedIndex(2);
                    break;
                }
                case 2: {
                    this.cLevel.setSelectedIndex(1);
                    break;
                }
                case 1: {
                    this.cLevel.setSelectedIndex(0);
                }
            }
            String langValue = this.languages.getProperty(user.getLanguage().toLowerCase());
            int index = this.sortedLangValues.indexOf(langValue);
            this.cLanguage.setSelectedIndex(index);
        } else {
            this.fUsername.setText("");
            ((JTextComponent)this.fPassword).setText("");
            ((JTextComponent)this.fConfirmPassword).setText("");
            this.fFullName.setText("");
            this.fEmail.setText("");
            this.fPhone.setText("");
            this.taAddress.setText("");
            this.cLevel.setSelectedIndex(0);
            String langValue = this.languages.getProperty("en");
            int index = this.sortedLangValues.indexOf(langValue);
            this.cLanguage.setSelectedIndex(index);
        }
    }

    public void updateUsersTree(UserAccount[] users) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject("UDDI User Groups");
        DefaultMutableTreeNode levelTier1 = new DefaultMutableTreeNode();
        levelTier1.setUserObject("Level Tier 1");
        root.add(levelTier1);
        DefaultMutableTreeNode levelTierN = new DefaultMutableTreeNode();
        levelTierN.setUserObject("Level Tier N");
        root.add(levelTierN);
        DefaultMutableTreeNode levelAdmin = new DefaultMutableTreeNode();
        levelAdmin.setUserObject("Level Admin");
        root.add(levelAdmin);
        int i = 0;
        while (i < users.length) {
            DefaultMutableTreeNode userNode = new DefaultMutableTreeNode();
            userNode.setUserObject(users[i]);
            switch (users[i].getLevel()) {
                case 3: {
                    levelAdmin.add(userNode);
                    break;
                }
                case 2: {
                    levelTierN.add(userNode);
                    break;
                }
                case 1: {
                    levelTier1.add(userNode);
                }
            }
            ++i;
        }
        this.tUDDIUsers.setModel(new DefaultTreeModel(root));
        this.tUDDIUsers.setSelectionRow(0);
    }

    private boolean isUserSelected() {
        if (this.tUDDIUsers.getSelectionPath() == null) {
            return false;
        }
        return this.tUDDIUsers.getSelectionPath().getPathCount() == 3;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.bNewUser) || source.equals(this.bEditUser)) {
            this.updateFieldsStatus(this.isUserSelected(), true, source.equals(this.bNewUser));
        } else if (source.equals(this.bRemoveUser)) {
            String username = this.getSelectedUser().getUsername();
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the user called " + username + "?", "Removing user", 0) == 0) {
                WSRuntimeView runtimeView = this.uddiServerPage.getWSRuntimeView();
                WSManagementInterface mi = runtimeView.getManagementInterface();
                RemoveUserTask taskItem = new RemoveUserTask(mi, username, this);
                Thread task = new Thread(taskItem);
                runtimeView.getTaskManager().addTask((TaskItem)taskItem);
                task.start();
            }
        } else if (source.equals(this.bSave)) {
            UserAccount user;
            char[] password = null;
            if (this.fUsername.isVisible()) {
                int i;
                char[] confirmedPass;
                boolean validPass;
                String username = this.fUsername.getText().trim().toLowerCase();
                if (username.length() == 0) {
                    JOptionPane.showMessageDialog(this, "Username cannot be empty", "Invalid Username", 0);
                    return;
                }
                UserAccount[] users = this.getAllUsers();
                int i2 = 0;
                while (i2 < users.length) {
                    if (username.equals(users[i2].getUsername())) {
                        JOptionPane.showMessageDialog(this, "There is such a user registerred", "User exists", 0);
                        return;
                    }
                    ++i2;
                }
                password = this.fPassword.getPassword();
                boolean bl = validPass = password.length == (confirmedPass = this.fConfirmPassword.getPassword()).length;
                if (validPass) {
                    i = 0;
                    while (i < password.length) {
                        if (password[i] != confirmedPass[i]) {
                            validPass = false;
                            break;
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < confirmedPass.length) {
                    confirmedPass[i] = '\u0000';
                    ++i;
                }
                if (!validPass) {
                    JOptionPane.showMessageDialog(this, "Passwords do not match", "Different passwords", 0);
                    return;
                }
                user = new UserAccount();
                user.setUsername(username);
            } else {
                user = this.getSelectedUser();
            }
            user.setFullName(this.fFullName.getText().trim());
            user.setEmail(this.fEmail.getText().trim());
            user.setPhone(this.fPhone.getText().trim());
            user.setAddress(this.taAddress.getText().trim());
            String selectedLanguage = this.sortedLangValues.elementAt(this.cLanguage.getSelectedIndex()).toString();
            user.setLanguage(this.reversedLanguages.getProperty(selectedLanguage));
            switch (this.cLevel.getSelectedIndex()) {
                case 0: {
                    user.setLevel(1);
                    break;
                }
                case 1: {
                    user.setLevel(2);
                    break;
                }
                case 2: {
                    user.setLevel(3);
                }
            }
            WSRuntimeView runtimeView = this.uddiServerPage.getWSRuntimeView();
            WSManagementInterface mi = runtimeView.getManagementInterface();
            UpdateUDDIUserTask taskItem = new UpdateUDDIUserTask(mi, user, password, this);
            Thread task = new Thread(taskItem);
            runtimeView.getTaskManager().addTask((TaskItem)taskItem);
            task.start();
        } else if (source.equals(this.bCancel)) {
            this.updateFieldsStatus(this.isUserSelected(), false, false);
        }
    }

    private void appendUsersToVector(Vector users, Object node, TreeModel model) {
        DefaultMutableTreeNode treeNode;
        if (node instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)node).getUserObject() instanceof UserAccount) {
            users.addElement(treeNode.getUserObject());
        }
        int count = model.getChildCount(node);
        int i = 0;
        while (i < count) {
            this.appendUsersToVector(users, model.getChild(node, i), model);
            ++i;
        }
    }

    private UserAccount[] getAllUsers() {
        TreeModel model = this.tUDDIUsers.getModel();
        Object root = model.getRoot();
        Vector users = new Vector();
        this.appendUsersToVector(users, root, model);
        Object[] userAccounts = new UserAccount[users.size()];
        users.copyInto(userAccounts);
        return userAccounts;
    }

    public void valueChanged(TreeSelectionEvent event) {
        this.updateFieldsStatus(this.isUserSelected(), false, false);
    }

    public UDDIServerPage getUDDIServerPage() {
        return this.uddiServerPage;
    }
}

