/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.services.webservices.gui.UDDIServerPage;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.helper.WSTableListener;
import com.sap.engine.services.webservices.gui.helper.WSTableModel;
import com.sap.engine.services.webservices.gui.tasks.ResetUDDIDBTask;
import com.sap.engine.services.webservices.gui.tasks.UpdateUDDIServerPropertyTask;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class UDDIServerGeneralPage
extends JPanel
implements ActionListener,
WSTableListener {
    private JTable tUDDIProperties;
    private JCheckBox cbPreload;
    private JButton bResetDB;
    private UDDIServerPage uddiServerPage;
    private JLabel isPreloadedLabel;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$gui$UDDIServerGeneralPage;

    public UDDIServerGeneralPage(UDDIServerPage uddiServerPage) {
        this.uddiServerPage = uddiServerPage;
        this.setLayout(new GridBagLayout());
        JPanel resetDBPanel = new JPanel(new GridBagLayout());
        resetDBPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Database"));
        this.isPreloadedLabel = new JLabel("Base tModels and Taxonomies have not been preloaded");
        URL iconURL = (class$com$sap$engine$services$webservices$gui$UDDIServerGeneralPage == null ? (class$com$sap$engine$services$webservices$gui$UDDIServerGeneralPage = UDDIServerGeneralPage.class$("com.sap.engine.services.webservices.gui.UDDIServerGeneralPage")) : class$com$sap$engine$services$webservices$gui$UDDIServerGeneralPage).getResource("/com/sap/engine/services/deploy/gui/images/warn.gif");
        if (iconURL != null) {
            ImageIcon warningIcon = new ImageIcon(iconURL);
            this.isPreloadedLabel.setIcon(warningIcon);
        }
        this.cbPreload = new JCheckBox("Preload base tModels and taxonomies (UNSPSC, ISO-3166, NAICS, etc...)", true);
        this.bResetDB = new JButton("Reset DB");
        this.bResetDB.addActionListener(this);
        resetDBPanel.add((Component)this.isPreloadedLabel, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 5, 5), 0, 0));
        resetDBPanel.add((Component)this.cbPreload, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        resetDBPanel.add((Component)this.bResetDB, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(10, 5, 0, 5), 0, 0));
        JPanel propertiesPanel = new JPanel(new BorderLayout());
        propertiesPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "UDDI Server Configuration"));
        JScrollPane propertiesPane = new JScrollPane();
        this.tUDDIProperties = new JTable();
        WSTableModel model = new WSTableModel(new String[0][2], "Property Name", "Value");
        model.setWSTableListener(this);
        model.setEditableColumn(1, true);
        this.tUDDIProperties.setModel(model);
        propertiesPane.getViewport().add(this.tUDDIProperties);
        propertiesPanel.add((Component)propertiesPane, "Center");
        this.add((Component)resetDBPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)propertiesPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.bResetDB) && JOptionPane.showConfirmDialog(this, "You are attempting to delete all data in the tables of the UDDI Server. Are you sure you want to continue?", "Reset UDDI Database", 0) == 0) {
            WSRuntimeView runtimeView = this.uddiServerPage.getWSRuntimeView();
            WSManagementInterface mi = runtimeView.getManagementInterface();
            ResetUDDIDBTask taskItem = new ResetUDDIDBTask(mi, this.cbPreload.isSelected(), this);
            Thread task = new Thread(taskItem);
            runtimeView.getTaskManager().addTask((TaskItem)taskItem);
            task.start();
        }
    }

    public void updateConfiguration(Properties props) {
        String[][] properties = new String[((Hashtable)props).keySet().size()][2];
        Enumeration enumeration = ((Hashtable)props).keys();
        int i = 0;
        while (i < properties.length) {
            String key = enumeration.nextElement().toString();
            String value = props.getProperty(key);
            properties[i][0] = key;
            properties[i][1] = value;
            ++i;
        }
        WSTableModel model = new WSTableModel(properties, "Property Name", "Value");
        model.setWSTableListener(this);
        model.setEditableColumn(1, true);
        this.tUDDIProperties.setModel(model);
    }

    public void updatePreloadedLabel(boolean preloaded) {
        this.isPreloadedLabel.setVisible(!preloaded);
    }

    public void cellEdited(int row, int col, Object newValue) {
        TableModel model = this.tUDDIProperties.getModel();
        String value = model.getValueAt(row, 1).toString();
        String key = model.getValueAt(row, 0).toString();
        WSRuntimeView runtimeView = this.uddiServerPage.getWSRuntimeView();
        WSManagementInterface mi = runtimeView.getManagementInterface();
        UpdateUDDIServerPropertyTask taskItem = new UpdateUDDIServerPropertyTask(mi, key, value);
        Thread task = new Thread(taskItem);
        task.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

