/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.interfaces.webservices.uddi4j.UDDIRegistry;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.helper.ListItem;
import com.sap.engine.services.webservices.gui.tasks.AddUDDIRegistryTask;
import com.sap.engine.services.webservices.gui.tasks.RemoveUDDIRegistryTask;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UDDIClientPage
extends JPanel
implements ListSelectionListener,
ActionListener {
    private JList lstUDDIRegistries;
    private JButton bNewRegistry;
    private JButton bEdit;
    private JButton bRemove;
    private JTextField fDisplayName;
    private JTextField fInquiryURL;
    private JTextField fPublishURL;
    private JButton bSave;
    private JButton bCancel;
    private boolean editButtonPressed;
    private WSRuntimeView runtimeView;

    public UDDIClientPage(WSRuntimeView runtimeView) {
        this.runtimeView = runtimeView;
        this.setLayout(new GridBagLayout());
        JPanel uddiClientPanel = new JPanel(new GridBagLayout());
        uddiClientPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "UDDI Registries"));
        JScrollPane registriesPane = new JScrollPane();
        this.lstUDDIRegistries = new JList();
        this.lstUDDIRegistries.addListSelectionListener(this);
        this.lstUDDIRegistries.setSelectionMode(0);
        registriesPane.getViewport().add(this.lstUDDIRegistries);
        uddiClientPanel.add((Component)new JLabel("Available Registries:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0));
        uddiClientPanel.add((Component)registriesPane, new GridBagConstraints(0, 1, 1, 8, 0.0, 0.1, 18, 1, new Insets(0, 5, 10, 5), 0, 0));
        this.bNewRegistry = new JButton("New Registry");
        this.bNewRegistry.addActionListener(this);
        uddiClientPanel.add((Component)this.bNewRegistry, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.bEdit = new JButton("Edit Registry");
        this.bEdit.addActionListener(this);
        uddiClientPanel.add((Component)this.bEdit, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.bRemove = new JButton("Remove Registry");
        this.bRemove.addActionListener(this);
        this.bRemove.setEnabled(false);
        uddiClientPanel.add((Component)this.bRemove, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        JPanel registryInfoPanel = new JPanel(new GridBagLayout());
        uddiClientPanel.add((Component)registryInfoPanel, new GridBagConstraints(1, 2, 3, 1, 0.1, 0.1, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        registryInfoPanel.add((Component)new JLabel("Registry Name:"), new GridBagConstraints(0, 0, 2, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.fDisplayName = new JTextField();
        registryInfoPanel.add((Component)this.fDisplayName, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 10, 5), 0, 0));
        registryInfoPanel.add((Component)new JLabel("Inquiry URL:"), new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.fInquiryURL = new JTextField();
        registryInfoPanel.add((Component)this.fInquiryURL, new GridBagConstraints(0, 3, 2, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 10, 5), 0, 0));
        registryInfoPanel.add((Component)new JLabel("Publish URL:"), new GridBagConstraints(0, 4, 2, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.fPublishURL = new JTextField();
        registryInfoPanel.add((Component)this.fPublishURL, new GridBagConstraints(0, 5, 2, 1, 0.1, 0.0, 18, 2, new Insets(0, 5, 10, 5), 0, 0));
        registryInfoPanel.add((Component)new JLabel("Use relative URIs if the registry points to the local server"), new GridBagConstraints(0, 6, 2, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.bSave = new JButton("Save");
        this.bSave.addActionListener(this);
        registryInfoPanel.add((Component)this.bSave, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.1, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        registryInfoPanel.add((Component)this.bCancel, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.1, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.updateEmptyUDDIRegistriesList();
        this.add((Component)uddiClientPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 11, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    private void updateEmptyUDDIRegistriesList() {
        this.fDisplayName.setText("");
        this.fInquiryURL.setText("");
        this.fPublishURL.setText("");
        this.fDisplayName.setEditable(false);
        this.fInquiryURL.setEditable(false);
        this.fPublishURL.setEditable(false);
        this.bNewRegistry.setEnabled(true);
        this.bEdit.setEnabled(false);
        this.bRemove.setEnabled(false);
        this.bSave.setVisible(false);
        this.bCancel.setVisible(false);
    }

    public void valueChanged(ListSelectionEvent event) {
        ListItem item;
        Object list = event.getSource();
        if (this.lstUDDIRegistries.equals(list) && (item = (ListItem)this.lstUDDIRegistries.getSelectedValue()) != null) {
            UDDIRegistry registry = (UDDIRegistry)item.getValue();
            this.updateRegistryInfo(registry, false);
        }
    }

    private void updateRegistryInfo(UDDIRegistry registry, boolean editMode) {
        this.fDisplayName.setText(registry.getName());
        this.fInquiryURL.setText(registry.getInquiryURL());
        this.fPublishURL.setText(registry.getPublishURL());
        this.fDisplayName.setEditable(false);
        this.fInquiryURL.setEditable(editMode);
        this.fPublishURL.setEditable(editMode);
        this.bNewRegistry.setEnabled(!editMode);
        this.bEdit.setEnabled(!editMode);
        this.bRemove.setEnabled(!editMode);
        this.bSave.setVisible(editMode);
        this.bCancel.setVisible(editMode);
        this.lstUDDIRegistries.setEnabled(!editMode);
    }

    protected void updateEmptyRegistryInfo() {
        this.fDisplayName.setText("");
        this.fInquiryURL.setText("");
        this.fPublishURL.setText("");
        this.fDisplayName.setEditable(true);
        this.fInquiryURL.setEditable(true);
        this.fPublishURL.setEditable(true);
        this.bNewRegistry.setEnabled(false);
        this.bEdit.setEnabled(false);
        this.bRemove.setEnabled(false);
        this.bSave.setVisible(true);
        this.bCancel.setVisible(true);
        this.lstUDDIRegistries.clearSelection();
        this.lstUDDIRegistries.setEnabled(false);
    }

    protected void updateSelectedRegistryInfo(boolean editMode) {
        ListItem selected = (ListItem)this.lstUDDIRegistries.getSelectedValue();
        this.updateRegistryInfo((UDDIRegistry)selected.getValue(), editMode);
    }

    public void actionPerformed(ActionEvent event) {
        Object button = event.getSource();
        if (this.bNewRegistry.equals(button)) {
            this.editButtonPressed = false;
            this.updateEmptyRegistryInfo();
        } else if (this.bEdit.equals(button)) {
            this.editButtonPressed = true;
            this.updateSelectedRegistryInfo(true);
        } else if (this.bRemove.equals(button)) {
            ListItem selected = (ListItem)this.lstUDDIRegistries.getSelectedValue();
            UDDIRegistry registry = (UDDIRegistry)selected.getValue();
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the UDDI Registry called " + registry.getName() + "?", "Removing UDDI Registry", 0) == 0) {
                ListModel model = this.lstUDDIRegistries.getModel();
                Vector newData = new Vector(model.getSize() - 1);
                int i = 0;
                while (i < model.getSize()) {
                    if (!this.lstUDDIRegistries.isSelectedIndex(i)) {
                        newData.addElement(model.getElementAt(i));
                    }
                    ++i;
                }
                this.lstUDDIRegistries.setListData(newData);
                if (this.lstUDDIRegistries.getModel().getSize() > 0) {
                    this.lstUDDIRegistries.setSelectedIndex(0);
                    this.updateSelectedRegistryInfo(false);
                } else {
                    this.updateEmptyUDDIRegistriesList();
                }
                this.removeRegistry(registry);
            }
        } else if (this.bSave.equals(button)) {
            String name = this.fDisplayName.getText().trim();
            String inquiryURL = this.fInquiryURL.getText().trim();
            String publishURL = this.fPublishURL.getText().trim();
            if (name.length() == 0 || inquiryURL.length() == 0 || publishURL.length() == 0) {
                JOptionPane.showMessageDialog(this, "Cannot add registry until all fields are filled!", "UDDI Registries", 0);
                return;
            }
            UDDIRegistry registry = new UDDIRegistry(name, inquiryURL, publishURL);
            ListModel model = this.lstUDDIRegistries.getModel();
            Vector<ListItem> newData = new Vector<ListItem>(model.getSize() + 1);
            boolean updating = false;
            int i = 0;
            while (i < model.getSize()) {
                ListItem item = (ListItem)model.getElementAt(i);
                UDDIRegistry reg = (UDDIRegistry)item.getValue();
                if (reg.getName().equals(name)) {
                    newData.addElement(new ListItem(registry.getName(), registry));
                    updating = true;
                    if (this.fDisplayName.isEditable() && JOptionPane.showConfirmDialog(this, "Such a registry exists! Do you want to update it?", "Overwrite", 0) == 1) {
                        return;
                    }
                } else {
                    newData.addElement(item);
                }
                ++i;
            }
            if (!updating) {
                newData.addElement(new ListItem(registry.getName(), registry));
            }
            int selectedIndex = this.lstUDDIRegistries.getSelectedIndex();
            if (this.editButtonPressed) {
                if (selectedIndex >= newData.size()) {
                    selectedIndex = 0;
                }
            } else {
                selectedIndex = newData.size() - 1;
            }
            this.lstUDDIRegistries.setListData(newData);
            this.lstUDDIRegistries.setSelectedIndex(selectedIndex);
            this.updateSelectedRegistryInfo(false);
            this.addNewRegistry(registry);
        } else if (this.bCancel.equals(button)) {
            this.lstUDDIRegistries.setEnabled(true);
            if (this.lstUDDIRegistries.getModel().getSize() > 0) {
                if (this.lstUDDIRegistries.isSelectionEmpty()) {
                    this.lstUDDIRegistries.setSelectedIndex(0);
                }
                this.updateSelectedRegistryInfo(false);
            } else {
                this.updateEmptyUDDIRegistriesList();
            }
        }
    }

    private void addNewRegistry(UDDIRegistry registry) {
        WSManagementInterface mi = this.runtimeView.getManagementInterface();
        AddUDDIRegistryTask taskItem = new AddUDDIRegistryTask(mi, registry);
        Thread task = new Thread(taskItem);
        this.runtimeView.getTaskManager().addTask((TaskItem)taskItem);
        task.start();
    }

    private void removeRegistry(UDDIRegistry registry) {
        WSManagementInterface mi = this.runtimeView.getManagementInterface();
        RemoveUDDIRegistryTask taskItem = new RemoveUDDIRegistryTask(mi, registry);
        Thread task = new Thread(taskItem);
        this.runtimeView.getTaskManager().addTask((TaskItem)taskItem);
        task.start();
    }

    public void updateFields(UDDIRegistry[] registries) {
        UDDIRegistry registry;
        ListItem[] listData = new ListItem[registries.length];
        int i = 0;
        while (i < registries.length) {
            registry = registries[i];
            listData[i] = new ListItem(registry.getName(), registry);
            ++i;
        }
        this.lstUDDIRegistries.setListData(listData);
        if (listData.length > 0) {
            this.lstUDDIRegistries.setSelectedIndex(0);
            registry = registries[0];
            this.updateRegistryInfo(registry, false);
        }
    }

    public UDDIRegistry[] getUDDIRegistries() {
        ListModel model = this.lstUDDIRegistries.getModel();
        UDDIRegistry[] registries = new UDDIRegistry[model.getSize()];
        int i = 0;
        while (i < registries.length) {
            ListItem item = (ListItem)model.getElementAt(i);
            registries[i] = (UDDIRegistry)item.getValue();
            ++i;
        }
        return registries;
    }
}

