/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.services.webservices.gui.WSRuntimeView;
import com.sap.engine.services.webservices.gui.tasks.SaveHTTPProxyTask;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SettingsPage
extends JPanel
implements ActionListener {
    private WSRuntimeView runtimeView;
    private JTextField fProxyHost;
    private JTextField fProxyPort;
    private JTextField fExcludeList;
    private JTextField fProxyUser;
    private JTextField fProxyPass;
    private JButton bSave;
    private JCheckBox cbBypass;

    public SettingsPage(WSRuntimeView runtimeView) {
        this.runtimeView = runtimeView;
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "HTTP Proxy Server Settings"));
        JLabel lProxyHost = new JLabel("Proxy Host: ");
        this.add((Component)lProxyHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fProxyHost = new JTextField();
        this.add((Component)this.fProxyHost, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(10, 5, 10, 5), 0, 0));
        JLabel lProxyPort = new JLabel("Proxy Port: ");
        this.add((Component)lProxyPort, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fProxyPort = new JTextField();
        this.add((Component)this.fProxyPort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 50, 0));
        JLabel lExcludeList = new JLabel("Exclude List: ");
        this.add((Component)lExcludeList, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fExcludeList = new JTextField();
        this.add((Component)this.fExcludeList, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        JLabel lProxyUser = new JLabel("Proxy User Name: ");
        this.add((Component)lProxyUser, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fProxyUser = new JTextField();
        this.add((Component)this.fProxyUser, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        JLabel lProxyPass = new JLabel("Proxy Password: ");
        this.add((Component)lProxyPass, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.fProxyPass = new JPasswordField();
        this.add((Component)this.fProxyPass, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.cbBypass = new JCheckBox("Bypass proxy server for local addresses");
        this.add((Component)this.cbBypass, new GridBagConstraints(0, 5, 2, 1, 0.1, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.bSave = new JButton("Save");
        this.bSave.addActionListener(this);
        this.add((Component)this.bSave, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 10, new Insets(10, 5, 10, 5), 0, 0));
    }

    public void updateProxy(HTTPProxy proxy) {
        String host = proxy.getProxyHost();
        String excludeList = proxy.getExcludeList();
        host = host == null ? "" : host.trim();
        excludeList = excludeList == null ? "" : excludeList.trim();
        this.fProxyHost.setText(host);
        if (host.length() > 0) {
            this.fProxyPort.setText(Integer.toString(proxy.getProxyPort()));
        } else {
            this.fProxyPort.setText("");
        }
        this.fExcludeList.setText(excludeList);
        this.cbBypass.setSelected(proxy.isBypassLocalAddresses());
        if (proxy.getProxyUser() != null) {
            this.fProxyUser.setText(proxy.getProxyUser());
        }
        if (proxy.getProxyPass() != null) {
            this.fProxyPass.setText(proxy.getProxyPass());
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.bSave)) {
            int proxyPort;
            String proxyHost = this.fProxyHost.getText().trim();
            try {
                proxyPort = Integer.parseInt(this.fProxyPort.getText().trim());
            }
            catch (NumberFormatException nfe) {
                if (proxyHost.length() == 0) {
                    proxyPort = -1;
                }
                JOptionPane.showMessageDialog(this, "HTTP Proxy port must be an integer", "HTTP Proxy", 0);
                return;
            }
            String excludeList = this.fExcludeList.getText().trim();
            HTTPProxy httpProxy = new HTTPProxy();
            if (proxyHost.length() > 0) {
                httpProxy.setProxyHost(proxyHost);
                httpProxy.setProxyPort(proxyPort);
                httpProxy.setExcludeList(excludeList);
                httpProxy.setBypassLocalAddresses(this.cbBypass.isSelected());
                String proxyUser = this.fProxyUser.getText().trim();
                String proxyPass = this.fProxyPass.getText().trim();
                if (proxyUser.length() > 0) {
                    httpProxy.setProxyUser(proxyUser);
                    httpProxy.setProxyPass(proxyPass);
                }
            }
            SaveHTTPProxyTask taskItem = new SaveHTTPProxyTask(this.runtimeView.getManagementInterface(), httpProxy);
            Thread task = new Thread(taskItem);
            this.runtimeView.getTaskManager().addTask((TaskItem)taskItem);
            task.start();
        }
    }
}

