/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.gui;

import com.sap.engine.interfaces.webservices.uddi4j.UDDIRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ModifyUDDIEntryDlg
extends JDialog
implements ActionListener {
    private JButton bOK;
    private JButton bCancel;
    private JTextField fServiceKey;
    private String serviceKey;
    private UDDIRegistry registry;
    private JComboBox cbRegistries;
    private int status = -1;

    public ModifyUDDIEntryDlg(Frame frame, UDDIRegistry[] registries, String serviceKey, boolean registriesOnly) {
        super(frame, "Select Registry", true);
        Container container = this.getContentPane();
        JLabel lServiceKey = null;
        if (!registriesOnly) {
            lServiceKey = new JLabel("Service Key: ");
            this.fServiceKey = new JTextField();
            if (serviceKey != null) {
                this.fServiceKey.setText(serviceKey);
                this.fServiceKey.setEditable(false);
            }
        }
        JLabel lRegistries = new JLabel("Select Registry: ");
        this.cbRegistries = new JComboBox<UDDIRegistry>(registries);
        this.cbRegistries.setSelectedIndex(0);
        this.bOK = new JButton("OK");
        this.bOK.setMnemonic('O');
        this.bOK.addActionListener(this);
        this.bCancel = new JButton("Cancel");
        this.bCancel.setMnemonic('C');
        this.bCancel.addActionListener(this);
        JPanel butPanel = new JPanel();
        butPanel.add(this.bOK);
        butPanel.add(this.bCancel);
        container.setLayout(new GridBagLayout());
        int line = 0;
        if (!registriesOnly) {
            container.add((Component)lServiceKey, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
            container.add((Component)this.fServiceKey, new GridBagConstraints(1, line++, 1, 1, 0.1, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
        }
        container.add((Component)lRegistries, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
        container.add((Component)this.cbRegistries, new GridBagConstraints(1, line++, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 10, 5), 0, 0));
        container.add((Component)butPanel, new GridBagConstraints(0, 2, line, 1, 0.0, 0.0, 15, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.getRootPane().setDefaultButton(this.bOK);
        ((Component)this).setSize(400, 200);
        Dimension dialogDim = this.getSize();
        Dimension frameDim = frame.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Point location = frame.getLocation();
        location.translate((frameDim.width - dialogDim.width) / 2, (frameDim.height - dialogDim.height) / 2);
        location.x = Math.max(0, Math.min(location.x, screenSize.width - this.getSize().width));
        location.y = Math.max(0, Math.min(location.y, screenSize.height - this.getSize().height));
        ((Component)this).setLocation(location.x, location.y);
    }

    public int getStatus() {
        return this.status;
    }

    public UDDIRegistry getSelectedRegistry() {
        return this.registry;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void actionPerformed(ActionEvent e) {
        Object button = e.getSource();
        if (button.equals(this.bOK)) {
            if (this.fServiceKey != null) {
                if (this.fServiceKey.isEditable() && this.fServiceKey.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this, "Please, specify a service key", "Service Key Missing", 0);
                    return;
                }
                this.serviceKey = this.fServiceKey.getText().trim();
            }
            this.registry = (UDDIRegistry)this.cbRegistries.getSelectedItem();
            this.status = 0;
            this.dispose();
        } else if (button.equals(this.bCancel)) {
            this.serviceKey = null;
            this.status = 2;
            this.dispose();
        }
    }
}

