/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.dispatcher;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.CommunicationClusterContext;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.session.CommunicationSessionProcessor;
import com.sap.engine.frame.cluster.session.PortNamePair;
import com.sap.engine.frame.cluster.transport.TransportSupplier;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.interfaces.log.LogInterface;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.webservices.common.OpenSocketRequest;
import com.sap.engine.services.webservices.dispatcher.WSClientsTransportSupplier;
import com.sap.engine.services.webservices.dispatcher.WSCommunicationProcessor;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Properties;

public class WebServicesDispatcherFrame
implements CommunicationServiceFrame,
MessageListener,
ContainerEventListener {
    public static final String WS_CLIENTS_SUPPLIER = "wsclients";
    private CommunicationServiceContext serviceContext = null;
    private WSCommunicationProcessor wsCommunicationProcessor = null;

    public void start(CommunicationServiceContext serviceContext) throws ServiceException {
        this.serviceContext = serviceContext;
        try {
            CommunicationClusterContext clusterContext = serviceContext.getClusterContext();
            clusterContext.getTransportContext().registerTransportSupplier(WS_CLIENTS_SUPPLIER, (TransportSupplier)new WSClientsTransportSupplier());
            clusterContext.getMessageContext().registerListener((MessageListener)this);
            this.wsCommunicationProcessor = new WSCommunicationProcessor();
            clusterContext.getCommunicationSessionContext().registerProcessor((CommunicationSessionProcessor)this.wsCommunicationProcessor);
            int mask = 192;
            HashSet<String> names = new HashSet<String>(1);
            names.add("log");
            serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
            wsLocation.catching((Throwable)e);
            throw new ServiceException("Unable to register wsCommunicationProcessor. Reason is: " + e.toString());
        }
    }

    public void stop() {
        this.serviceContext.getClusterContext().getMessageContext().unregisterListener();
        this.serviceContext.getClusterContext().getTransportContext().unregisterTransportSupplier(WS_CLIENTS_SUPPLIER);
        this.serviceContext.getClusterContext().getCommunicationSessionContext().unregisterProcessor();
        this.wsCommunicationProcessor = null;
    }

    public void receive(int clusterId, int messageType, byte[] body, int offset, int length) {
    }

    public MessageAnswer receiveWait(int clusterId, int requestId, byte[] body, int offset, int length) {
        switch (requestId) {
            case 0: {
                return this.getConnectionIDAnswer(clusterId, body, offset, length);
            }
            case 2: {
                return this.getPortAnswer("http|ssl");
            }
            case 3: {
                return this.getPortAnswer("http");
            }
        }
        return null;
    }

    private MessageAnswer getConnectionIDAnswer(int clusterId, byte[] body, int offset, int length) {
        int connectionId = -1;
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(body, offset, length));
            OpenSocketRequest openSocketRequest = (OpenSocketRequest)in.readObject();
            String host = openSocketRequest.getHost();
            int port = openSocketRequest.getPort();
            this.serviceContext.getCoreContext().getPoolContext().release(body);
            connectionId = this.serviceContext.getClusterContext().getCommunicationSessionContext().openSocket(host, port, WS_CLIENTS_SUPPLIER);
            this.wsCommunicationProcessor.getConnectionApplicationMapping().put(connectionId, clusterId);
            this.wsCommunicationProcessor.initializeSocketOfConnection(connectionId, openSocketRequest);
        }
        catch (Exception e) {
            connectionId = -1;
            Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
            wsLocation.catching((Throwable)e);
        }
        return new MessageAnswer(Convert.intArrToByteArr((int[])new int[]{connectionId}));
    }

    private MessageAnswer getPortAnswer(String portType) {
        try {
            PortNamePair[] portNamePairs = this.serviceContext.getClusterContext().getCommunicationSessionContext().getUsedPorts();
            int port = -1;
            int i = 0;
            while (i < portNamePairs.length) {
                PortNamePair pair = portNamePairs[i];
                if (portType.equals(pair.getName())) {
                    port = pair.getPort();
                    break;
                }
                ++i;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(port);
            dataOut.flush();
            byte[] body = out.toByteArray();
            return new MessageAnswer(body);
        }
        catch (Throwable thr) {
            Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
            wsLocation.catching(thr);
            return new MessageAnswer(new byte[0]);
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("log")) {
            LogInterface log = (LogInterface)interfaceImpl;
            log.activateLogger("webservices");
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void markForShutdown(long time) {
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return false;
    }
}

