/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.dispatcher;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.session.ApplicationConnection;
import com.sap.engine.frame.cluster.session.ClientConnection;
import com.sap.engine.frame.cluster.session.CommunicationSessionProcessor;
import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.frame.cluster.session.ConnectionMonitor;
import com.sap.engine.frame.cluster.session.Data;
import com.sap.engine.lib.util.HashMapIntInt;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.webservices.common.OpenSocketRequest;
import com.sap.engine.services.webservices.dispatcher.WSClientsSocket;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.tc.logging.Location;
import java.io.IOException;

public class WSCommunicationProcessor
implements CommunicationSessionProcessor {
    private HashMapIntInt connectionApplicationMapping = new HashMapIntInt();
    private HashMapIntObject wsClientSockets = new HashMapIntObject();

    public void parseRequest(Connection connection, ApplicationConnection application, ClientConnection client) {
        connection.setDestinationId(this.connectionApplicationMapping.get(connection.getConnectionId()));
        try {
            Data data = connection.getRequestData();
            if (data.getLength() > 0) {
                application.send(connection);
            }
        }
        catch (ClusterException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
            wsLocation.catching((Throwable)e);
        }
    }

    public boolean memoryWarning(Connection connection, ApplicationConnection application, ClientConnection client, boolean forced) {
        return false;
    }

    public void parseReply(Connection connection, ApplicationConnection application, ClientConnection client) {
        Data data = connection.getReplyData();
        connection.setPrivateData((Object)application);
        client.send(connection, data.getBytes(), data.getOffset(), data.getLength());
        if (data.getFlag() == 1) {
            this.wsClientSockets.remove(connection.getConnectionId());
            connection.closeConnection();
        }
    }

    public void initialize(Connection connection, ConnectionMonitor monitor) {
        this.wsClientSockets.put(connection.getConnectionId(), (Object)monitor.getSocket());
    }

    public void fail(Connection connection, ConnectionMonitor monitor) {
        try {
            ApplicationConnection con = (ApplicationConnection)connection.getPrivateData();
            if (con != null && connection.getConnectionId() != -1) {
                con.send(connection, new byte[0], 0, 0);
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
            wsLocation.catching((Throwable)e);
        }
    }

    public HashMapIntInt getConnectionApplicationMapping() {
        return this.connectionApplicationMapping;
    }

    public void initializeSocketOfConnection(int connectionID, OpenSocketRequest request) throws IOException {
        WSClientsSocket wscSocket;
        Object socket = this.wsClientSockets.get(connectionID);
        if (socket == null) {
            throw new IOException("Cannot find socket for this connectionID: " + connectionID);
        }
        if (socket instanceof WSClientsSocket) {
            wscSocket = (WSClientsSocket)socket;
            wscSocket.setProxy(request.getProxyHost(), request.getProxyPort());
            if (request.isSslSocket()) {
                wscSocket.setSecure(true);
                wscSocket.setClientCertificateList(request.getClientCertificateList());
                wscSocket.setServerCertificateList(request.getServerCertificateList());
            }
        } else {
            throw new IOException("Expected WSClientsSocket, found object of class: " + socket.getClass().getName());
        }
        wscSocket.initialize();
    }
}

