/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.dispatcher;

import com.sap.engine.services.webservices.dispatcher.WSClientsSocketInputStream;
import com.sap.engine.services.webservices.dispatcher.WSClientsSocketOutputStream;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxm.soap.SSLSocketUtilInterface;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;

public class WSClientsSocket
extends Socket {
    private String host;
    private int port;
    private String proxyHost;
    private int proxyPort;
    private Socket socket;
    private boolean secure = false;
    private List clientCertificateList;
    private List serverCertificateList;
    private WSClientsSocketInputStream inputStream;
    private WSClientsSocketOutputStream outputStream;
    private int soTimeout = -1;

    public WSClientsSocket(String host, int port) {
        this.host = host;
        this.port = port;
        this.inputStream = new WSClientsSocketInputStream();
        this.outputStream = new WSClientsSocketOutputStream();
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setClientCertificateList(List clientCertificateList) {
        this.clientCertificateList = clientCertificateList;
    }

    public void setServerCertificateList(List serverCertificateList) {
        this.serverCertificateList = serverCertificateList;
    }

    public void initialize() throws IOException {
        if (this.port == -1) {
            this.port = this.secure ? 443 : 80;
        }
        if (this.secure) {
            SSLSocketUtilInterface sslUtil;
            try {
                Class<?> sslUtilsClass = Class.forName("com.sap.engine.services.webservices.jaxm.soap.SSLUtilImpl");
                sslUtil = (SSLSocketUtilInterface)sslUtilsClass.newInstance();
            }
            catch (Throwable ex) {
                throw new IOException("SSL not available: " + ex.toString());
            }
            this.socket = this.proxyHost != null ? sslUtil.createSSLSocket(this.host, this.port, this.proxyHost, this.proxyPort, this.clientCertificateList, this.serverCertificateList, true) : sslUtil.createSSLSocket(this.host, this.port, this.clientCertificateList, this.serverCertificateList, true);
        } else {
            this.socket = this.proxyHost == null ? new Socket(this.host, this.port) : new Socket(this.proxyHost, this.proxyPort);
        }
        if (this.soTimeout != -1) {
            this.socket.setSoTimeout(this.soTimeout);
        }
        this.outputStream.initialize(this.socket.getOutputStream());
        this.inputStream.initialize(this.socket.getInputStream());
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public InetAddress getInetAddress() {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getLocalAddress();
    }

    public int getPort() {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getPort();
    }

    public int getLocalPort() {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getLocalPort();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.setSoLinger(on, linger);
    }

    public int getSoLinger() throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getSoLinger();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.socket == null) {
            this.soTimeout = timeout;
        } else {
            this.socket.setSoTimeout(timeout);
        }
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.socket == null) {
            if (this.soTimeout != -1) {
                return this.soTimeout;
            }
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getSoTimeout();
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.setSendBufferSize(size);
    }

    public synchronized int getSendBufferSize() throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getSendBufferSize();
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.setReceiveBufferSize(size);
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getReceiveBufferSize();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.setKeepAlive(on);
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        return this.socket.getKeepAlive();
    }

    public synchronized void close() throws IOException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.close();
    }

    public void shutdownInput() throws IOException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new IllegalStateException("First initialize the socket and then call this method. ");
            }
        }
        this.socket.shutdownOutput();
    }

    public String toString() {
        if (this.socket == null) {
            try {
                throw new Exception("First initialize the socket and then call this method. ");
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.WEBSERVICES_LOCATION);
                wsLocation.catching((Throwable)e);
                return "Disconnected WSClientsSocket to host = " + this.host + ", port = " + this.port;
            }
        }
        return "WSClientsSocket connected to " + this.socket.toString();
    }
}

